/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.httpclient;

import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.apache.shenyu.plugin.httpclient.AbstractHttpClientPlugin;
import org.apache.shenyu.plugin.httpclient.RetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class FixedRetryStrategy<R>
implements RetryStrategy<R> {
    private static final Logger LOG = LoggerFactory.getLogger(FixedRetryStrategy.class);
    private final AbstractHttpClientPlugin<R> httpClientPlugin;

    public FixedRetryStrategy(AbstractHttpClientPlugin<R> httpClientPlugin) {
        this.httpClientPlugin = httpClientPlugin;
    }

    @Override
    public Mono<R> execute(Mono<R> response, ServerWebExchange exchange, Duration duration, int retryTimes) {
        Retry retrySpec = this.initFixedBackoff(retryTimes);
        return response.retryWhen(retrySpec).timeout(duration, Mono.error(() -> new TimeoutException("Response took longer than timeout: " + duration))).doOnError(e -> LOG.error(e.getMessage(), e));
    }

    private Retry initFixedBackoff(int retryTimes) {
        return Retry.fixedDelay((long)retryTimes, (Duration)Duration.ofSeconds(2L));
    }
}

