/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch.tasks.TaskInfo;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetTasksResponse
implements JsonpSerializable {
    private final boolean completed;
    private final TaskInfo task;
    @Nullable
    private final JsonData response;
    @Nullable
    private final ErrorCause error;
    public static final JsonpDeserializer<GetTasksResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetTasksResponse::setupGetTasksResponseDeserializer);

    private GetTasksResponse(Builder builder) {
        this.completed = ApiTypeHelper.requireNonNull(builder.completed, this, "completed");
        this.task = ApiTypeHelper.requireNonNull(builder.task, this, "task");
        this.response = builder.response;
        this.error = builder.error;
    }

    public static GetTasksResponse of(Function<Builder, ObjectBuilder<GetTasksResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean completed() {
        return this.completed;
    }

    public final TaskInfo task() {
        return this.task;
    }

    @Nullable
    public final JsonData response() {
        return this.response;
    }

    @Nullable
    public final ErrorCause error() {
        return this.error;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("completed");
        generator.write(this.completed);
        generator.writeKey("task");
        this.task.serialize(generator, mapper);
        if (this.response != null) {
            generator.writeKey("response");
            this.response.serialize(generator, mapper);
        }
        if (this.error != null) {
            generator.writeKey("error");
            this.error.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetTasksResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::completed, JsonpDeserializer.booleanDeserializer(), "completed");
        op.add(Builder::task, TaskInfo._DESERIALIZER, "task");
        op.add(Builder::response, JsonData._DESERIALIZER, "response");
        op.add(Builder::error, ErrorCause._DESERIALIZER, "error");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetTasksResponse> {
        private Boolean completed;
        private TaskInfo task;
        @Nullable
        private JsonData response;
        @Nullable
        private ErrorCause error;

        public final Builder completed(boolean value) {
            this.completed = value;
            return this;
        }

        public final Builder task(TaskInfo value) {
            this.task = value;
            return this;
        }

        public final Builder task(Function<TaskInfo.Builder, ObjectBuilder<TaskInfo>> fn) {
            return this.task(fn.apply(new TaskInfo.Builder()).build());
        }

        public final Builder response(@Nullable JsonData value) {
            this.response = value;
            return this;
        }

        public final Builder error(@Nullable ErrorCause value) {
            this.error = value;
            return this;
        }

        public final Builder error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetTasksResponse build() {
            this._checkSingleUse();
            return new GetTasksResponse(this);
        }
    }
}

