/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.msearch;

import co.elastic.clients.elasticsearch.core.msearch.MultiSearchResponseItem;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class MultiSearchResult<TDocument>
implements JsonpSerializable {
    private final long took;
    private final List<MultiSearchResponseItem<TDocument>> responses;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    protected MultiSearchResult(AbstractBuilder<TDocument, ?> builder) {
        this.took = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).took, this, "took");
        this.responses = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).responses, (Object)this, "responses");
        this.tDocumentSerializer = ((AbstractBuilder)builder).tDocumentSerializer;
    }

    public final long took() {
        return this.took;
    }

    public final List<MultiSearchResponseItem<TDocument>> responses() {
        return this.responses;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("took");
        generator.write(this.took);
        if (ApiTypeHelper.isDefined(this.responses)) {
            generator.writeKey("responses");
            generator.writeStartArray();
            for (MultiSearchResponseItem<TDocument> item0 : this.responses) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <TDocument, BuilderT extends AbstractBuilder<TDocument, BuilderT>> void setupMultiSearchResultDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(AbstractBuilder::took, JsonpDeserializer.longDeserializer(), "took");
        op.add(AbstractBuilder::responses, JsonpDeserializer.arrayDeserializer(MultiSearchResponseItem.createMultiSearchResponseItemDeserializer(tDocumentDeserializer)), "responses");
    }

    public static abstract class AbstractBuilder<TDocument, BuilderT extends AbstractBuilder<TDocument, BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private Long took;
        private List<MultiSearchResponseItem<TDocument>> responses;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final BuilderT took(long value) {
            this.took = value;
            return (BuilderT)this.self();
        }

        public final BuilderT responses(List<MultiSearchResponseItem<TDocument>> list) {
            this.responses = AbstractBuilder._listAddAll(this.responses, list);
            return (BuilderT)this.self();
        }

        public final BuilderT responses(MultiSearchResponseItem<TDocument> value, MultiSearchResponseItem<TDocument> ... values) {
            this.responses = AbstractBuilder._listAdd(this.responses, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT responses(Function<MultiSearchResponseItem.Builder<TDocument>, ObjectBuilder<MultiSearchResponseItem<TDocument>>> fn) {
            return this.responses(fn.apply(new MultiSearchResponseItem.Builder()).build(), new MultiSearchResponseItem[0]);
        }

        public final BuilderT tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

