/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import io.grpc.alts.internal.Endpoint;
import io.grpc.alts.internal.EndpointOrBuilder;
import io.grpc.alts.internal.HandshakeProtocol;
import io.grpc.alts.internal.HandshakerProto;
import io.grpc.alts.internal.Identity;
import io.grpc.alts.internal.IdentityOrBuilder;
import io.grpc.alts.internal.RpcProtocolVersions;
import io.grpc.alts.internal.RpcProtocolVersionsOrBuilder;
import io.grpc.alts.internal.StartClientHandshakeReqOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class StartClientHandshakeReq
extends GeneratedMessageV3
implements StartClientHandshakeReqOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int HANDSHAKE_SECURITY_PROTOCOL_FIELD_NUMBER = 1;
    private int handshakeSecurityProtocol_;
    public static final int APPLICATION_PROTOCOLS_FIELD_NUMBER = 2;
    private LazyStringList applicationProtocols_;
    public static final int RECORD_PROTOCOLS_FIELD_NUMBER = 3;
    private LazyStringList recordProtocols_;
    public static final int TARGET_IDENTITIES_FIELD_NUMBER = 4;
    private List<Identity> targetIdentities_;
    public static final int LOCAL_IDENTITY_FIELD_NUMBER = 5;
    private Identity localIdentity_;
    public static final int LOCAL_ENDPOINT_FIELD_NUMBER = 6;
    private Endpoint localEndpoint_;
    public static final int REMOTE_ENDPOINT_FIELD_NUMBER = 7;
    private Endpoint remoteEndpoint_;
    public static final int TARGET_NAME_FIELD_NUMBER = 8;
    private volatile Object targetName_;
    public static final int RPC_VERSIONS_FIELD_NUMBER = 9;
    private RpcProtocolVersions rpcVersions_;
    public static final int MAX_FRAME_SIZE_FIELD_NUMBER = 10;
    private int maxFrameSize_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final StartClientHandshakeReq DEFAULT_INSTANCE = new StartClientHandshakeReq();
    private static final Parser<StartClientHandshakeReq> PARSER = new AbstractParser<StartClientHandshakeReq>(){

        public StartClientHandshakeReq parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = StartClientHandshakeReq.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private StartClientHandshakeReq(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private StartClientHandshakeReq() {
        this.handshakeSecurityProtocol_ = 0;
        this.applicationProtocols_ = LazyStringArrayList.EMPTY;
        this.recordProtocols_ = LazyStringArrayList.EMPTY;
        this.targetIdentities_ = Collections.emptyList();
        this.targetName_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new StartClientHandshakeReq();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return HandshakerProto.internal_static_grpc_gcp_StartClientHandshakeReq_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return HandshakerProto.internal_static_grpc_gcp_StartClientHandshakeReq_fieldAccessorTable.ensureFieldAccessorsInitialized(StartClientHandshakeReq.class, Builder.class);
    }

    @Override
    public int getHandshakeSecurityProtocolValue() {
        return this.handshakeSecurityProtocol_;
    }

    @Override
    public HandshakeProtocol getHandshakeSecurityProtocol() {
        HandshakeProtocol result = HandshakeProtocol.valueOf(this.handshakeSecurityProtocol_);
        return result == null ? HandshakeProtocol.UNRECOGNIZED : result;
    }

    public ProtocolStringList getApplicationProtocolsList() {
        return this.applicationProtocols_;
    }

    @Override
    public int getApplicationProtocolsCount() {
        return this.applicationProtocols_.size();
    }

    @Override
    public String getApplicationProtocols(int index) {
        return (String)this.applicationProtocols_.get(index);
    }

    @Override
    public ByteString getApplicationProtocolsBytes(int index) {
        return this.applicationProtocols_.getByteString(index);
    }

    public ProtocolStringList getRecordProtocolsList() {
        return this.recordProtocols_;
    }

    @Override
    public int getRecordProtocolsCount() {
        return this.recordProtocols_.size();
    }

    @Override
    public String getRecordProtocols(int index) {
        return (String)this.recordProtocols_.get(index);
    }

    @Override
    public ByteString getRecordProtocolsBytes(int index) {
        return this.recordProtocols_.getByteString(index);
    }

    @Override
    public List<Identity> getTargetIdentitiesList() {
        return this.targetIdentities_;
    }

    @Override
    public List<? extends IdentityOrBuilder> getTargetIdentitiesOrBuilderList() {
        return this.targetIdentities_;
    }

    @Override
    public int getTargetIdentitiesCount() {
        return this.targetIdentities_.size();
    }

    @Override
    public Identity getTargetIdentities(int index) {
        return this.targetIdentities_.get(index);
    }

    @Override
    public IdentityOrBuilder getTargetIdentitiesOrBuilder(int index) {
        return this.targetIdentities_.get(index);
    }

    @Override
    public boolean hasLocalIdentity() {
        return this.localIdentity_ != null;
    }

    @Override
    public Identity getLocalIdentity() {
        return this.localIdentity_ == null ? Identity.getDefaultInstance() : this.localIdentity_;
    }

    @Override
    public IdentityOrBuilder getLocalIdentityOrBuilder() {
        return this.getLocalIdentity();
    }

    @Override
    public boolean hasLocalEndpoint() {
        return this.localEndpoint_ != null;
    }

    @Override
    public Endpoint getLocalEndpoint() {
        return this.localEndpoint_ == null ? Endpoint.getDefaultInstance() : this.localEndpoint_;
    }

    @Override
    public EndpointOrBuilder getLocalEndpointOrBuilder() {
        return this.getLocalEndpoint();
    }

    @Override
    public boolean hasRemoteEndpoint() {
        return this.remoteEndpoint_ != null;
    }

    @Override
    public Endpoint getRemoteEndpoint() {
        return this.remoteEndpoint_ == null ? Endpoint.getDefaultInstance() : this.remoteEndpoint_;
    }

    @Override
    public EndpointOrBuilder getRemoteEndpointOrBuilder() {
        return this.getRemoteEndpoint();
    }

    @Override
    public String getTargetName() {
        Object ref = this.targetName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.targetName_ = s;
        return s;
    }

    @Override
    public ByteString getTargetNameBytes() {
        Object ref = this.targetName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.targetName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasRpcVersions() {
        return this.rpcVersions_ != null;
    }

    @Override
    public RpcProtocolVersions getRpcVersions() {
        return this.rpcVersions_ == null ? RpcProtocolVersions.getDefaultInstance() : this.rpcVersions_;
    }

    @Override
    public RpcProtocolVersionsOrBuilder getRpcVersionsOrBuilder() {
        return this.getRpcVersions();
    }

    @Override
    public int getMaxFrameSize() {
        return this.maxFrameSize_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (this.handshakeSecurityProtocol_ != HandshakeProtocol.HANDSHAKE_PROTOCOL_UNSPECIFIED.getNumber()) {
            output.writeEnum(1, this.handshakeSecurityProtocol_);
        }
        for (i = 0; i < this.applicationProtocols_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.applicationProtocols_.getRaw(i));
        }
        for (i = 0; i < this.recordProtocols_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.recordProtocols_.getRaw(i));
        }
        for (i = 0; i < this.targetIdentities_.size(); ++i) {
            output.writeMessage(4, (MessageLite)this.targetIdentities_.get(i));
        }
        if (this.localIdentity_ != null) {
            output.writeMessage(5, (MessageLite)this.getLocalIdentity());
        }
        if (this.localEndpoint_ != null) {
            output.writeMessage(6, (MessageLite)this.getLocalEndpoint());
        }
        if (this.remoteEndpoint_ != null) {
            output.writeMessage(7, (MessageLite)this.getRemoteEndpoint());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.targetName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.targetName_);
        }
        if (this.rpcVersions_ != null) {
            output.writeMessage(9, (MessageLite)this.getRpcVersions());
        }
        if (this.maxFrameSize_ != 0) {
            output.writeUInt32(10, this.maxFrameSize_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.handshakeSecurityProtocol_ != HandshakeProtocol.HANDSHAKE_PROTOCOL_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)1, (int)this.handshakeSecurityProtocol_);
        }
        int dataSize = 0;
        for (i = 0; i < this.applicationProtocols_.size(); ++i) {
            dataSize += StartClientHandshakeReq.computeStringSizeNoTag((Object)this.applicationProtocols_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getApplicationProtocolsList().size();
        dataSize = 0;
        for (i = 0; i < this.recordProtocols_.size(); ++i) {
            dataSize += StartClientHandshakeReq.computeStringSizeNoTag((Object)this.recordProtocols_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getRecordProtocolsList().size();
        for (int i2 = 0; i2 < this.targetIdentities_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)((MessageLite)this.targetIdentities_.get(i2)));
        }
        if (this.localIdentity_ != null) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getLocalIdentity());
        }
        if (this.localEndpoint_ != null) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getLocalEndpoint());
        }
        if (this.remoteEndpoint_ != null) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getRemoteEndpoint());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.targetName_)) {
            size += GeneratedMessageV3.computeStringSize((int)8, (Object)this.targetName_);
        }
        if (this.rpcVersions_ != null) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getRpcVersions());
        }
        if (this.maxFrameSize_ != 0) {
            size += CodedOutputStream.computeUInt32Size((int)10, (int)this.maxFrameSize_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StartClientHandshakeReq)) {
            return super.equals(obj);
        }
        StartClientHandshakeReq other = (StartClientHandshakeReq)obj;
        if (this.handshakeSecurityProtocol_ != other.handshakeSecurityProtocol_) {
            return false;
        }
        if (!this.getApplicationProtocolsList().equals(other.getApplicationProtocolsList())) {
            return false;
        }
        if (!this.getRecordProtocolsList().equals(other.getRecordProtocolsList())) {
            return false;
        }
        if (!this.getTargetIdentitiesList().equals(other.getTargetIdentitiesList())) {
            return false;
        }
        if (this.hasLocalIdentity() != other.hasLocalIdentity()) {
            return false;
        }
        if (this.hasLocalIdentity() && !this.getLocalIdentity().equals(other.getLocalIdentity())) {
            return false;
        }
        if (this.hasLocalEndpoint() != other.hasLocalEndpoint()) {
            return false;
        }
        if (this.hasLocalEndpoint() && !this.getLocalEndpoint().equals(other.getLocalEndpoint())) {
            return false;
        }
        if (this.hasRemoteEndpoint() != other.hasRemoteEndpoint()) {
            return false;
        }
        if (this.hasRemoteEndpoint() && !this.getRemoteEndpoint().equals(other.getRemoteEndpoint())) {
            return false;
        }
        if (!this.getTargetName().equals(other.getTargetName())) {
            return false;
        }
        if (this.hasRpcVersions() != other.hasRpcVersions()) {
            return false;
        }
        if (this.hasRpcVersions() && !this.getRpcVersions().equals(other.getRpcVersions())) {
            return false;
        }
        if (this.getMaxFrameSize() != other.getMaxFrameSize()) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + StartClientHandshakeReq.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.handshakeSecurityProtocol_;
        if (this.getApplicationProtocolsCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getApplicationProtocolsList().hashCode();
        }
        if (this.getRecordProtocolsCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getRecordProtocolsList().hashCode();
        }
        if (this.getTargetIdentitiesCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getTargetIdentitiesList().hashCode();
        }
        if (this.hasLocalIdentity()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getLocalIdentity().hashCode();
        }
        if (this.hasLocalEndpoint()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getLocalEndpoint().hashCode();
        }
        if (this.hasRemoteEndpoint()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getRemoteEndpoint().hashCode();
        }
        hash = 37 * hash + 8;
        hash = 53 * hash + this.getTargetName().hashCode();
        if (this.hasRpcVersions()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getRpcVersions().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + this.getMaxFrameSize();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static StartClientHandshakeReq parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (StartClientHandshakeReq)PARSER.parseFrom(data);
    }

    public static StartClientHandshakeReq parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (StartClientHandshakeReq)PARSER.parseFrom(data, extensionRegistry);
    }

    public static StartClientHandshakeReq parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (StartClientHandshakeReq)PARSER.parseFrom(data);
    }

    public static StartClientHandshakeReq parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (StartClientHandshakeReq)PARSER.parseFrom(data, extensionRegistry);
    }

    public static StartClientHandshakeReq parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (StartClientHandshakeReq)PARSER.parseFrom(data);
    }

    public static StartClientHandshakeReq parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (StartClientHandshakeReq)PARSER.parseFrom(data, extensionRegistry);
    }

    public static StartClientHandshakeReq parseFrom(InputStream input) throws IOException {
        return (StartClientHandshakeReq)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static StartClientHandshakeReq parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (StartClientHandshakeReq)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static StartClientHandshakeReq parseDelimitedFrom(InputStream input) throws IOException {
        return (StartClientHandshakeReq)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static StartClientHandshakeReq parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (StartClientHandshakeReq)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static StartClientHandshakeReq parseFrom(CodedInputStream input) throws IOException {
        return (StartClientHandshakeReq)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static StartClientHandshakeReq parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (StartClientHandshakeReq)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return StartClientHandshakeReq.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(StartClientHandshakeReq prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static StartClientHandshakeReq getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<StartClientHandshakeReq> parser() {
        return PARSER;
    }

    public Parser<StartClientHandshakeReq> getParserForType() {
        return PARSER;
    }

    public StartClientHandshakeReq getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements StartClientHandshakeReqOrBuilder {
        private int bitField0_;
        private int handshakeSecurityProtocol_ = 0;
        private LazyStringList applicationProtocols_ = LazyStringArrayList.EMPTY;
        private LazyStringList recordProtocols_ = LazyStringArrayList.EMPTY;
        private List<Identity> targetIdentities_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Identity, Identity.Builder, IdentityOrBuilder> targetIdentitiesBuilder_;
        private Identity localIdentity_;
        private SingleFieldBuilderV3<Identity, Identity.Builder, IdentityOrBuilder> localIdentityBuilder_;
        private Endpoint localEndpoint_;
        private SingleFieldBuilderV3<Endpoint, Endpoint.Builder, EndpointOrBuilder> localEndpointBuilder_;
        private Endpoint remoteEndpoint_;
        private SingleFieldBuilderV3<Endpoint, Endpoint.Builder, EndpointOrBuilder> remoteEndpointBuilder_;
        private Object targetName_ = "";
        private RpcProtocolVersions rpcVersions_;
        private SingleFieldBuilderV3<RpcProtocolVersions, RpcProtocolVersions.Builder, RpcProtocolVersionsOrBuilder> rpcVersionsBuilder_;
        private int maxFrameSize_;

        public static final Descriptors.Descriptor getDescriptor() {
            return HandshakerProto.internal_static_grpc_gcp_StartClientHandshakeReq_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return HandshakerProto.internal_static_grpc_gcp_StartClientHandshakeReq_fieldAccessorTable.ensureFieldAccessorsInitialized(StartClientHandshakeReq.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.handshakeSecurityProtocol_ = 0;
            this.applicationProtocols_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.recordProtocols_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFD;
            if (this.targetIdentitiesBuilder_ == null) {
                this.targetIdentities_ = Collections.emptyList();
            } else {
                this.targetIdentities_ = null;
                this.targetIdentitiesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFB;
            if (this.localIdentityBuilder_ == null) {
                this.localIdentity_ = null;
            } else {
                this.localIdentity_ = null;
                this.localIdentityBuilder_ = null;
            }
            if (this.localEndpointBuilder_ == null) {
                this.localEndpoint_ = null;
            } else {
                this.localEndpoint_ = null;
                this.localEndpointBuilder_ = null;
            }
            if (this.remoteEndpointBuilder_ == null) {
                this.remoteEndpoint_ = null;
            } else {
                this.remoteEndpoint_ = null;
                this.remoteEndpointBuilder_ = null;
            }
            this.targetName_ = "";
            if (this.rpcVersionsBuilder_ == null) {
                this.rpcVersions_ = null;
            } else {
                this.rpcVersions_ = null;
                this.rpcVersionsBuilder_ = null;
            }
            this.maxFrameSize_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return HandshakerProto.internal_static_grpc_gcp_StartClientHandshakeReq_descriptor;
        }

        public StartClientHandshakeReq getDefaultInstanceForType() {
            return StartClientHandshakeReq.getDefaultInstance();
        }

        public StartClientHandshakeReq build() {
            StartClientHandshakeReq result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public StartClientHandshakeReq buildPartial() {
            StartClientHandshakeReq result = new StartClientHandshakeReq(this);
            int from_bitField0_ = this.bitField0_;
            result.handshakeSecurityProtocol_ = this.handshakeSecurityProtocol_;
            if ((this.bitField0_ & 1) != 0) {
                this.applicationProtocols_ = this.applicationProtocols_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.applicationProtocols_ = this.applicationProtocols_;
            if ((this.bitField0_ & 2) != 0) {
                this.recordProtocols_ = this.recordProtocols_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.recordProtocols_ = this.recordProtocols_;
            if (this.targetIdentitiesBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.targetIdentities_ = Collections.unmodifiableList(this.targetIdentities_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.targetIdentities_ = this.targetIdentities_;
            } else {
                result.targetIdentities_ = this.targetIdentitiesBuilder_.build();
            }
            if (this.localIdentityBuilder_ == null) {
                result.localIdentity_ = this.localIdentity_;
            } else {
                result.localIdentity_ = (Identity)this.localIdentityBuilder_.build();
            }
            if (this.localEndpointBuilder_ == null) {
                result.localEndpoint_ = this.localEndpoint_;
            } else {
                result.localEndpoint_ = (Endpoint)this.localEndpointBuilder_.build();
            }
            if (this.remoteEndpointBuilder_ == null) {
                result.remoteEndpoint_ = this.remoteEndpoint_;
            } else {
                result.remoteEndpoint_ = (Endpoint)this.remoteEndpointBuilder_.build();
            }
            result.targetName_ = this.targetName_;
            if (this.rpcVersionsBuilder_ == null) {
                result.rpcVersions_ = this.rpcVersions_;
            } else {
                result.rpcVersions_ = (RpcProtocolVersions)this.rpcVersionsBuilder_.build();
            }
            result.maxFrameSize_ = this.maxFrameSize_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof StartClientHandshakeReq) {
                return this.mergeFrom((StartClientHandshakeReq)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(StartClientHandshakeReq other) {
            if (other == StartClientHandshakeReq.getDefaultInstance()) {
                return this;
            }
            if (other.handshakeSecurityProtocol_ != 0) {
                this.setHandshakeSecurityProtocolValue(other.getHandshakeSecurityProtocolValue());
            }
            if (!other.applicationProtocols_.isEmpty()) {
                if (this.applicationProtocols_.isEmpty()) {
                    this.applicationProtocols_ = other.applicationProtocols_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureApplicationProtocolsIsMutable();
                    this.applicationProtocols_.addAll((Collection)other.applicationProtocols_);
                }
                this.onChanged();
            }
            if (!other.recordProtocols_.isEmpty()) {
                if (this.recordProtocols_.isEmpty()) {
                    this.recordProtocols_ = other.recordProtocols_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureRecordProtocolsIsMutable();
                    this.recordProtocols_.addAll((Collection)other.recordProtocols_);
                }
                this.onChanged();
            }
            if (this.targetIdentitiesBuilder_ == null) {
                if (!other.targetIdentities_.isEmpty()) {
                    if (this.targetIdentities_.isEmpty()) {
                        this.targetIdentities_ = other.targetIdentities_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensureTargetIdentitiesIsMutable();
                        this.targetIdentities_.addAll(other.targetIdentities_);
                    }
                    this.onChanged();
                }
            } else if (!other.targetIdentities_.isEmpty()) {
                if (this.targetIdentitiesBuilder_.isEmpty()) {
                    this.targetIdentitiesBuilder_.dispose();
                    this.targetIdentitiesBuilder_ = null;
                    this.targetIdentities_ = other.targetIdentities_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.targetIdentitiesBuilder_ = alwaysUseFieldBuilders ? this.getTargetIdentitiesFieldBuilder() : null;
                } else {
                    this.targetIdentitiesBuilder_.addAllMessages((Iterable)other.targetIdentities_);
                }
            }
            if (other.hasLocalIdentity()) {
                this.mergeLocalIdentity(other.getLocalIdentity());
            }
            if (other.hasLocalEndpoint()) {
                this.mergeLocalEndpoint(other.getLocalEndpoint());
            }
            if (other.hasRemoteEndpoint()) {
                this.mergeRemoteEndpoint(other.getRemoteEndpoint());
            }
            if (!other.getTargetName().isEmpty()) {
                this.targetName_ = other.targetName_;
                this.onChanged();
            }
            if (other.hasRpcVersions()) {
                this.mergeRpcVersions(other.getRpcVersions());
            }
            if (other.getMaxFrameSize() != 0) {
                this.setMaxFrameSize(other.getMaxFrameSize());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block18: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block18;
                        }
                        case 8: {
                            this.handshakeSecurityProtocol_ = input.readEnum();
                            continue block18;
                        }
                        case 18: {
                            String s = input.readStringRequireUtf8();
                            this.ensureApplicationProtocolsIsMutable();
                            this.applicationProtocols_.add((Object)s);
                            continue block18;
                        }
                        case 26: {
                            String s = input.readStringRequireUtf8();
                            this.ensureRecordProtocolsIsMutable();
                            this.recordProtocols_.add((Object)s);
                            continue block18;
                        }
                        case 34: {
                            Identity m = (Identity)input.readMessage(Identity.parser(), extensionRegistry);
                            if (this.targetIdentitiesBuilder_ == null) {
                                this.ensureTargetIdentitiesIsMutable();
                                this.targetIdentities_.add(m);
                                continue block18;
                            }
                            this.targetIdentitiesBuilder_.addMessage((AbstractMessage)m);
                            continue block18;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getLocalIdentityFieldBuilder().getBuilder(), extensionRegistry);
                            continue block18;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getLocalEndpointFieldBuilder().getBuilder(), extensionRegistry);
                            continue block18;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getRemoteEndpointFieldBuilder().getBuilder(), extensionRegistry);
                            continue block18;
                        }
                        case 66: {
                            this.targetName_ = input.readStringRequireUtf8();
                            continue block18;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getRpcVersionsFieldBuilder().getBuilder(), extensionRegistry);
                            continue block18;
                        }
                        case 80: {
                            this.maxFrameSize_ = input.readUInt32();
                            continue block18;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public int getHandshakeSecurityProtocolValue() {
            return this.handshakeSecurityProtocol_;
        }

        public Builder setHandshakeSecurityProtocolValue(int value) {
            this.handshakeSecurityProtocol_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public HandshakeProtocol getHandshakeSecurityProtocol() {
            HandshakeProtocol result = HandshakeProtocol.valueOf(this.handshakeSecurityProtocol_);
            return result == null ? HandshakeProtocol.UNRECOGNIZED : result;
        }

        public Builder setHandshakeSecurityProtocol(HandshakeProtocol value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.handshakeSecurityProtocol_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearHandshakeSecurityProtocol() {
            this.handshakeSecurityProtocol_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureApplicationProtocolsIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.applicationProtocols_ = new LazyStringArrayList(this.applicationProtocols_);
                this.bitField0_ |= 1;
            }
        }

        public ProtocolStringList getApplicationProtocolsList() {
            return this.applicationProtocols_.getUnmodifiableView();
        }

        @Override
        public int getApplicationProtocolsCount() {
            return this.applicationProtocols_.size();
        }

        @Override
        public String getApplicationProtocols(int index) {
            return (String)this.applicationProtocols_.get(index);
        }

        @Override
        public ByteString getApplicationProtocolsBytes(int index) {
            return this.applicationProtocols_.getByteString(index);
        }

        public Builder setApplicationProtocols(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureApplicationProtocolsIsMutable();
            this.applicationProtocols_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addApplicationProtocols(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureApplicationProtocolsIsMutable();
            this.applicationProtocols_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllApplicationProtocols(Iterable<String> values) {
            this.ensureApplicationProtocolsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.applicationProtocols_);
            this.onChanged();
            return this;
        }

        public Builder clearApplicationProtocols() {
            this.applicationProtocols_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder addApplicationProtocolsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            StartClientHandshakeReq.checkByteStringIsUtf8((ByteString)value);
            this.ensureApplicationProtocolsIsMutable();
            this.applicationProtocols_.add(value);
            this.onChanged();
            return this;
        }

        private void ensureRecordProtocolsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.recordProtocols_ = new LazyStringArrayList(this.recordProtocols_);
                this.bitField0_ |= 2;
            }
        }

        public ProtocolStringList getRecordProtocolsList() {
            return this.recordProtocols_.getUnmodifiableView();
        }

        @Override
        public int getRecordProtocolsCount() {
            return this.recordProtocols_.size();
        }

        @Override
        public String getRecordProtocols(int index) {
            return (String)this.recordProtocols_.get(index);
        }

        @Override
        public ByteString getRecordProtocolsBytes(int index) {
            return this.recordProtocols_.getByteString(index);
        }

        public Builder setRecordProtocols(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRecordProtocolsIsMutable();
            this.recordProtocols_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addRecordProtocols(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRecordProtocolsIsMutable();
            this.recordProtocols_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllRecordProtocols(Iterable<String> values) {
            this.ensureRecordProtocolsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.recordProtocols_);
            this.onChanged();
            return this;
        }

        public Builder clearRecordProtocols() {
            this.recordProtocols_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder addRecordProtocolsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            StartClientHandshakeReq.checkByteStringIsUtf8((ByteString)value);
            this.ensureRecordProtocolsIsMutable();
            this.recordProtocols_.add(value);
            this.onChanged();
            return this;
        }

        private void ensureTargetIdentitiesIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.targetIdentities_ = new ArrayList<Identity>(this.targetIdentities_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<Identity> getTargetIdentitiesList() {
            if (this.targetIdentitiesBuilder_ == null) {
                return Collections.unmodifiableList(this.targetIdentities_);
            }
            return this.targetIdentitiesBuilder_.getMessageList();
        }

        @Override
        public int getTargetIdentitiesCount() {
            if (this.targetIdentitiesBuilder_ == null) {
                return this.targetIdentities_.size();
            }
            return this.targetIdentitiesBuilder_.getCount();
        }

        @Override
        public Identity getTargetIdentities(int index) {
            if (this.targetIdentitiesBuilder_ == null) {
                return this.targetIdentities_.get(index);
            }
            return (Identity)this.targetIdentitiesBuilder_.getMessage(index);
        }

        public Builder setTargetIdentities(int index, Identity value) {
            if (this.targetIdentitiesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTargetIdentitiesIsMutable();
                this.targetIdentities_.set(index, value);
                this.onChanged();
            } else {
                this.targetIdentitiesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setTargetIdentities(int index, Identity.Builder builderForValue) {
            if (this.targetIdentitiesBuilder_ == null) {
                this.ensureTargetIdentitiesIsMutable();
                this.targetIdentities_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.targetIdentitiesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addTargetIdentities(Identity value) {
            if (this.targetIdentitiesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTargetIdentitiesIsMutable();
                this.targetIdentities_.add(value);
                this.onChanged();
            } else {
                this.targetIdentitiesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addTargetIdentities(int index, Identity value) {
            if (this.targetIdentitiesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTargetIdentitiesIsMutable();
                this.targetIdentities_.add(index, value);
                this.onChanged();
            } else {
                this.targetIdentitiesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addTargetIdentities(Identity.Builder builderForValue) {
            if (this.targetIdentitiesBuilder_ == null) {
                this.ensureTargetIdentitiesIsMutable();
                this.targetIdentities_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.targetIdentitiesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addTargetIdentities(int index, Identity.Builder builderForValue) {
            if (this.targetIdentitiesBuilder_ == null) {
                this.ensureTargetIdentitiesIsMutable();
                this.targetIdentities_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.targetIdentitiesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllTargetIdentities(Iterable<? extends Identity> values) {
            if (this.targetIdentitiesBuilder_ == null) {
                this.ensureTargetIdentitiesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.targetIdentities_);
                this.onChanged();
            } else {
                this.targetIdentitiesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearTargetIdentities() {
            if (this.targetIdentitiesBuilder_ == null) {
                this.targetIdentities_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.targetIdentitiesBuilder_.clear();
            }
            return this;
        }

        public Builder removeTargetIdentities(int index) {
            if (this.targetIdentitiesBuilder_ == null) {
                this.ensureTargetIdentitiesIsMutable();
                this.targetIdentities_.remove(index);
                this.onChanged();
            } else {
                this.targetIdentitiesBuilder_.remove(index);
            }
            return this;
        }

        public Identity.Builder getTargetIdentitiesBuilder(int index) {
            return (Identity.Builder)this.getTargetIdentitiesFieldBuilder().getBuilder(index);
        }

        @Override
        public IdentityOrBuilder getTargetIdentitiesOrBuilder(int index) {
            if (this.targetIdentitiesBuilder_ == null) {
                return this.targetIdentities_.get(index);
            }
            return (IdentityOrBuilder)this.targetIdentitiesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends IdentityOrBuilder> getTargetIdentitiesOrBuilderList() {
            if (this.targetIdentitiesBuilder_ != null) {
                return this.targetIdentitiesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.targetIdentities_);
        }

        public Identity.Builder addTargetIdentitiesBuilder() {
            return (Identity.Builder)this.getTargetIdentitiesFieldBuilder().addBuilder((AbstractMessage)Identity.getDefaultInstance());
        }

        public Identity.Builder addTargetIdentitiesBuilder(int index) {
            return (Identity.Builder)this.getTargetIdentitiesFieldBuilder().addBuilder(index, (AbstractMessage)Identity.getDefaultInstance());
        }

        public List<Identity.Builder> getTargetIdentitiesBuilderList() {
            return this.getTargetIdentitiesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Identity, Identity.Builder, IdentityOrBuilder> getTargetIdentitiesFieldBuilder() {
            if (this.targetIdentitiesBuilder_ == null) {
                this.targetIdentitiesBuilder_ = new RepeatedFieldBuilderV3(this.targetIdentities_, (this.bitField0_ & 4) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.targetIdentities_ = null;
            }
            return this.targetIdentitiesBuilder_;
        }

        @Override
        public boolean hasLocalIdentity() {
            return this.localIdentityBuilder_ != null || this.localIdentity_ != null;
        }

        @Override
        public Identity getLocalIdentity() {
            if (this.localIdentityBuilder_ == null) {
                return this.localIdentity_ == null ? Identity.getDefaultInstance() : this.localIdentity_;
            }
            return (Identity)this.localIdentityBuilder_.getMessage();
        }

        public Builder setLocalIdentity(Identity value) {
            if (this.localIdentityBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.localIdentity_ = value;
                this.onChanged();
            } else {
                this.localIdentityBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setLocalIdentity(Identity.Builder builderForValue) {
            if (this.localIdentityBuilder_ == null) {
                this.localIdentity_ = builderForValue.build();
                this.onChanged();
            } else {
                this.localIdentityBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeLocalIdentity(Identity value) {
            if (this.localIdentityBuilder_ == null) {
                this.localIdentity_ = this.localIdentity_ != null ? Identity.newBuilder(this.localIdentity_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.localIdentityBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearLocalIdentity() {
            if (this.localIdentityBuilder_ == null) {
                this.localIdentity_ = null;
                this.onChanged();
            } else {
                this.localIdentity_ = null;
                this.localIdentityBuilder_ = null;
            }
            return this;
        }

        public Identity.Builder getLocalIdentityBuilder() {
            this.onChanged();
            return (Identity.Builder)this.getLocalIdentityFieldBuilder().getBuilder();
        }

        @Override
        public IdentityOrBuilder getLocalIdentityOrBuilder() {
            if (this.localIdentityBuilder_ != null) {
                return (IdentityOrBuilder)this.localIdentityBuilder_.getMessageOrBuilder();
            }
            return this.localIdentity_ == null ? Identity.getDefaultInstance() : this.localIdentity_;
        }

        private SingleFieldBuilderV3<Identity, Identity.Builder, IdentityOrBuilder> getLocalIdentityFieldBuilder() {
            if (this.localIdentityBuilder_ == null) {
                this.localIdentityBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLocalIdentity(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.localIdentity_ = null;
            }
            return this.localIdentityBuilder_;
        }

        @Override
        public boolean hasLocalEndpoint() {
            return this.localEndpointBuilder_ != null || this.localEndpoint_ != null;
        }

        @Override
        public Endpoint getLocalEndpoint() {
            if (this.localEndpointBuilder_ == null) {
                return this.localEndpoint_ == null ? Endpoint.getDefaultInstance() : this.localEndpoint_;
            }
            return (Endpoint)this.localEndpointBuilder_.getMessage();
        }

        public Builder setLocalEndpoint(Endpoint value) {
            if (this.localEndpointBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.localEndpoint_ = value;
                this.onChanged();
            } else {
                this.localEndpointBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setLocalEndpoint(Endpoint.Builder builderForValue) {
            if (this.localEndpointBuilder_ == null) {
                this.localEndpoint_ = builderForValue.build();
                this.onChanged();
            } else {
                this.localEndpointBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeLocalEndpoint(Endpoint value) {
            if (this.localEndpointBuilder_ == null) {
                this.localEndpoint_ = this.localEndpoint_ != null ? Endpoint.newBuilder(this.localEndpoint_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.localEndpointBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearLocalEndpoint() {
            if (this.localEndpointBuilder_ == null) {
                this.localEndpoint_ = null;
                this.onChanged();
            } else {
                this.localEndpoint_ = null;
                this.localEndpointBuilder_ = null;
            }
            return this;
        }

        public Endpoint.Builder getLocalEndpointBuilder() {
            this.onChanged();
            return (Endpoint.Builder)this.getLocalEndpointFieldBuilder().getBuilder();
        }

        @Override
        public EndpointOrBuilder getLocalEndpointOrBuilder() {
            if (this.localEndpointBuilder_ != null) {
                return (EndpointOrBuilder)this.localEndpointBuilder_.getMessageOrBuilder();
            }
            return this.localEndpoint_ == null ? Endpoint.getDefaultInstance() : this.localEndpoint_;
        }

        private SingleFieldBuilderV3<Endpoint, Endpoint.Builder, EndpointOrBuilder> getLocalEndpointFieldBuilder() {
            if (this.localEndpointBuilder_ == null) {
                this.localEndpointBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLocalEndpoint(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.localEndpoint_ = null;
            }
            return this.localEndpointBuilder_;
        }

        @Override
        public boolean hasRemoteEndpoint() {
            return this.remoteEndpointBuilder_ != null || this.remoteEndpoint_ != null;
        }

        @Override
        public Endpoint getRemoteEndpoint() {
            if (this.remoteEndpointBuilder_ == null) {
                return this.remoteEndpoint_ == null ? Endpoint.getDefaultInstance() : this.remoteEndpoint_;
            }
            return (Endpoint)this.remoteEndpointBuilder_.getMessage();
        }

        public Builder setRemoteEndpoint(Endpoint value) {
            if (this.remoteEndpointBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.remoteEndpoint_ = value;
                this.onChanged();
            } else {
                this.remoteEndpointBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setRemoteEndpoint(Endpoint.Builder builderForValue) {
            if (this.remoteEndpointBuilder_ == null) {
                this.remoteEndpoint_ = builderForValue.build();
                this.onChanged();
            } else {
                this.remoteEndpointBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeRemoteEndpoint(Endpoint value) {
            if (this.remoteEndpointBuilder_ == null) {
                this.remoteEndpoint_ = this.remoteEndpoint_ != null ? Endpoint.newBuilder(this.remoteEndpoint_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.remoteEndpointBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearRemoteEndpoint() {
            if (this.remoteEndpointBuilder_ == null) {
                this.remoteEndpoint_ = null;
                this.onChanged();
            } else {
                this.remoteEndpoint_ = null;
                this.remoteEndpointBuilder_ = null;
            }
            return this;
        }

        public Endpoint.Builder getRemoteEndpointBuilder() {
            this.onChanged();
            return (Endpoint.Builder)this.getRemoteEndpointFieldBuilder().getBuilder();
        }

        @Override
        public EndpointOrBuilder getRemoteEndpointOrBuilder() {
            if (this.remoteEndpointBuilder_ != null) {
                return (EndpointOrBuilder)this.remoteEndpointBuilder_.getMessageOrBuilder();
            }
            return this.remoteEndpoint_ == null ? Endpoint.getDefaultInstance() : this.remoteEndpoint_;
        }

        private SingleFieldBuilderV3<Endpoint, Endpoint.Builder, EndpointOrBuilder> getRemoteEndpointFieldBuilder() {
            if (this.remoteEndpointBuilder_ == null) {
                this.remoteEndpointBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRemoteEndpoint(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.remoteEndpoint_ = null;
            }
            return this.remoteEndpointBuilder_;
        }

        @Override
        public String getTargetName() {
            Object ref = this.targetName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.targetName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTargetNameBytes() {
            Object ref = this.targetName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.targetName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTargetName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.targetName_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearTargetName() {
            this.targetName_ = StartClientHandshakeReq.getDefaultInstance().getTargetName();
            this.onChanged();
            return this;
        }

        public Builder setTargetNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            StartClientHandshakeReq.checkByteStringIsUtf8((ByteString)value);
            this.targetName_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasRpcVersions() {
            return this.rpcVersionsBuilder_ != null || this.rpcVersions_ != null;
        }

        @Override
        public RpcProtocolVersions getRpcVersions() {
            if (this.rpcVersionsBuilder_ == null) {
                return this.rpcVersions_ == null ? RpcProtocolVersions.getDefaultInstance() : this.rpcVersions_;
            }
            return (RpcProtocolVersions)this.rpcVersionsBuilder_.getMessage();
        }

        public Builder setRpcVersions(RpcProtocolVersions value) {
            if (this.rpcVersionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.rpcVersions_ = value;
                this.onChanged();
            } else {
                this.rpcVersionsBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setRpcVersions(RpcProtocolVersions.Builder builderForValue) {
            if (this.rpcVersionsBuilder_ == null) {
                this.rpcVersions_ = builderForValue.build();
                this.onChanged();
            } else {
                this.rpcVersionsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeRpcVersions(RpcProtocolVersions value) {
            if (this.rpcVersionsBuilder_ == null) {
                this.rpcVersions_ = this.rpcVersions_ != null ? RpcProtocolVersions.newBuilder(this.rpcVersions_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.rpcVersionsBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearRpcVersions() {
            if (this.rpcVersionsBuilder_ == null) {
                this.rpcVersions_ = null;
                this.onChanged();
            } else {
                this.rpcVersions_ = null;
                this.rpcVersionsBuilder_ = null;
            }
            return this;
        }

        public RpcProtocolVersions.Builder getRpcVersionsBuilder() {
            this.onChanged();
            return (RpcProtocolVersions.Builder)this.getRpcVersionsFieldBuilder().getBuilder();
        }

        @Override
        public RpcProtocolVersionsOrBuilder getRpcVersionsOrBuilder() {
            if (this.rpcVersionsBuilder_ != null) {
                return (RpcProtocolVersionsOrBuilder)this.rpcVersionsBuilder_.getMessageOrBuilder();
            }
            return this.rpcVersions_ == null ? RpcProtocolVersions.getDefaultInstance() : this.rpcVersions_;
        }

        private SingleFieldBuilderV3<RpcProtocolVersions, RpcProtocolVersions.Builder, RpcProtocolVersionsOrBuilder> getRpcVersionsFieldBuilder() {
            if (this.rpcVersionsBuilder_ == null) {
                this.rpcVersionsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRpcVersions(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.rpcVersions_ = null;
            }
            return this.rpcVersionsBuilder_;
        }

        @Override
        public int getMaxFrameSize() {
            return this.maxFrameSize_;
        }

        public Builder setMaxFrameSize(int value) {
            this.maxFrameSize_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearMaxFrameSize() {
            this.maxFrameSize_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

