/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.exception.ShenyuAdminException;
import org.apache.shenyu.admin.mapper.ScaleRuleMapper;
import org.apache.shenyu.admin.model.dto.ScaleRuleDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.ScaleRuleQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.ScaleRuleVO;
import org.apache.shenyu.admin.service.ScaleRuleService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@RestApi(value={"/scale/rule"})
public class ScaleRlueController {
    private final ScaleRuleService scaleRuleService;
    private final ScaleRuleMapper scaleRuleMapper;

    public ScaleRlueController(ScaleRuleService scaleRuleService, ScaleRuleMapper scaleRuleMapper) {
        this.scaleRuleService = scaleRuleService;
        this.scaleRuleMapper = scaleRuleMapper;
    }

    @GetMapping(value={"/getAllRules"})
    public ShenyuAdminResult selectAll() {
        return ShenyuAdminResult.success("query success", this.scaleRuleService.selectAll());
    }

    @GetMapping
    public ShenyuAdminResult queryRule(String metricName, Integer type, Integer status, @RequestParam @NotNull Integer currentPage, @RequestParam @NotNull Integer pageSize) {
        CommonPager<ScaleRuleVO> commonPager = this.scaleRuleService.listByPage(new ScaleRuleQuery(metricName, type, status, new PageParameter(currentPage, pageSize)));
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/{id}"})
    public ShenyuAdminResult detailRule(@PathVariable(value="id") @Valid @Existed(provider=ScaleRuleMapper.class, message="scale role is not existed") @Valid @Existed(provider=ScaleRuleMapper.class, message="scale role is not existed") String id) {
        ScaleRuleVO scaleRuleVO = this.scaleRuleService.findById(id);
        return Optional.ofNullable(scaleRuleVO).map(item -> ShenyuAdminResult.success("detail success", item)).orElse(ShenyuAdminResult.error("detail failed"));
    }

    @PostMapping
    public ShenyuAdminResult createRule(@Valid @RequestBody ScaleRuleDTO scaleRuleDTO) {
        return ShenyuAdminResult.success("create success", this.scaleRuleService.createOrUpdate(scaleRuleDTO));
    }

    @PutMapping
    public ShenyuAdminResult updateRule(@Valid @RequestBody ScaleRuleDTO scaleRuleDTO) {
        if (!this.scaleRuleMapper.existed((Serializable)((Object)scaleRuleDTO.getId())).booleanValue()) {
            throw new ShenyuAdminException("scale rule is not existed");
        }
        return ShenyuAdminResult.success("update success", this.scaleRuleService.createOrUpdate(scaleRuleDTO));
    }

    @DeleteMapping(value={"/batch"})
    public ShenyuAdminResult deleteRules(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        return ShenyuAdminResult.success("delete success", this.scaleRuleService.delete(ids));
    }
}

