/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zookeeper.metadata;

import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.utils.CloseableUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.metadata.ListenableMetadataStore;
import org.springframework.integration.metadata.MetadataStoreListener;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.integration.zookeeper.metadata.ZookeeperMetadataStoreException;
import org.springframework.util.Assert;

public class ZookeeperMetadataStore
implements ListenableMetadataStore,
SmartLifecycle {
    private static final String KEY_MUST_NOT_BE_NULL = "'key' must not be null.";
    private final CuratorFramework client;
    private final List<MetadataStoreListener> listeners = new CopyOnWriteArrayList<MetadataStoreListener>();
    private final ConcurrentMap<String, LocalChildData> updateMap = new ConcurrentHashMap<String, LocalChildData>();
    private String root = "/SpringIntegration-MetadataStore";
    private String encoding = StandardCharsets.UTF_8.name();
    private CuratorCache cache;
    private boolean autoStartup = true;
    private int phase = Integer.MAX_VALUE;
    private boolean running;
    private final Lock lock = new ReentrantLock();

    public ZookeeperMetadataStore(CuratorFramework client) {
        Assert.notNull((Object)client, (String)"Client cannot be null");
        this.client = client;
    }

    public void setEncoding(String encoding) {
        Assert.hasText((String)encoding, (String)"'encoding' cannot be null or empty.");
        this.encoding = encoding;
    }

    public void setRoot(String root) {
        Assert.notNull((Object)root, (String)"'root' must not be null.");
        Assert.isTrue((root.charAt(0) == '/' ? 1 : 0) != 0, (String)"'root' must start with '/'");
        this.root = "/".equals(root) || !root.endsWith("/") ? root : root.substring(0, root.length() - 1);
    }

    public String getRoot() {
        return this.root;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    /*
     * Loose catch block
     */
    public String putIfAbsent(String key, String value) {
        this.lock.lock();
        try {
            Assert.notNull((Object)key, (String)KEY_MUST_NOT_BE_NULL);
            Assert.notNull((Object)value, (String)"'value' must not be null.");
            try {
                this.createNode(key, value);
                String string = null;
                return string;
            }
            catch (KeeperException.NodeExistsException ex) {
                String string = this.get(key);
                this.lock.unlock();
                return string;
            }
            catch (Exception ex) {
                throw new ZookeeperMetadataStoreException("Error while trying to set '" + key + "':", ex);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Loose catch block
     */
    public boolean replace(String key, String oldValue, String newValue) {
        this.lock.lock();
        try {
            Assert.notNull((Object)key, (String)KEY_MUST_NOT_BE_NULL);
            Assert.notNull((Object)oldValue, (String)"'oldValue' must not be null.");
            Assert.notNull((Object)newValue, (String)"'newValue' must not be null.");
            Stat currentStat = new Stat();
            try {
                byte[] bytes = (byte[])((WatchPathable)this.client.getData().storingStatIn(currentStat)).forPath(this.getPath(key));
                if (oldValue.equals(IntegrationUtils.bytesToString((byte[])bytes, (String)this.encoding))) {
                    this.updateNode(key, newValue, currentStat.getVersion());
                }
                boolean bl = true;
                return bl;
            }
            catch (KeeperException.BadVersionException | KeeperException.NoNodeException ex) {
                boolean bl = false;
                this.lock.unlock();
                return bl;
            }
            catch (Exception ex) {
                throw new ZookeeperMetadataStoreException("Cannot replace value", ex);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addListener(MetadataStoreListener listener) {
        Assert.notNull((Object)listener, (String)"'listener' must not be null");
        this.listeners.add(listener);
    }

    public void removeListener(MetadataStoreListener callback) {
        this.listeners.remove(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, String value) {
        this.lock.lock();
        try {
            Assert.notNull((Object)key, (String)KEY_MUST_NOT_BE_NULL);
            Assert.notNull((Object)value, (String)"'value' must not be null.");
            try {
                Stat currentNode = (Stat)this.client.checkExists().forPath(this.getPath(key));
                if (currentNode == null) {
                    try {
                        this.createNode(key, value);
                    }
                    catch (KeeperException.NodeExistsException e) {
                        this.updateNode(key, value, -1);
                    }
                } else {
                    this.updateNode(key, value, -1);
                }
            }
            catch (Exception ex) {
                throw new ZookeeperMetadataStoreException("Error while setting value for key '" + key + "':", ex);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String get(String key) {
        this.lock.lock();
        try {
            Assert.notNull((Object)key, (String)KEY_MUST_NOT_BE_NULL);
            Assert.state((boolean)this.isRunning(), (String)"ZookeeperMetadataStore has to be started before using.");
            String string = this.cache.get(this.getPath(key)).map(currentData -> {
                if (this.updateMap.containsKey(key) && ((LocalChildData)this.updateMap.get(key)).version() >= currentData.getStat().getVersion()) {
                    return ((LocalChildData)this.updateMap.get(key)).value();
                }
                return IntegrationUtils.bytesToString((byte[])currentData.getData(), (String)this.encoding);
            }).orElseGet(() -> {
                if (this.updateMap.containsKey(key)) {
                    return ((LocalChildData)this.updateMap.get(key)).value();
                }
                return null;
            });
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Loose catch block
     */
    public String remove(String key) {
        this.lock.lock();
        try {
            Assert.notNull((Object)key, (String)KEY_MUST_NOT_BE_NULL);
            try {
                byte[] bytes = (byte[])this.client.getData().forPath(this.getPath(key));
                this.client.delete().forPath(this.getPath(key));
                this.updateMap.put(key, new LocalChildData(null, Integer.MAX_VALUE));
                String string = IntegrationUtils.bytesToString((byte[])bytes, (String)this.encoding);
                return string;
            }
            catch (KeeperException.NoNodeException ex) {
                String string = null;
                this.lock.unlock();
                return string;
            }
            catch (Exception ex) {
                throw new ZookeeperMetadataStoreException("Exception while deleting key '" + key + "'", ex);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateNode(String key, String value, int version) throws Exception {
        Stat stat = (Stat)((BackgroundPathAndBytesable)this.client.setData().withVersion(version)).forPath(this.getPath(key), IntegrationUtils.stringToBytes((String)value, (String)this.encoding));
        this.updateMap.put(key, new LocalChildData(value, stat.getVersion()));
    }

    private void createNode(String key, String value) throws Exception {
        this.client.create().forPath(this.getPath(key), IntegrationUtils.stringToBytes((String)value, (String)this.encoding));
        this.updateMap.put(key, new LocalChildData(value, 0));
    }

    public String getPath(String key) {
        return "".equals(key) ? this.root : this.root + "/" + key;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void start() {
        block5: {
            this.lock.lock();
            try {
                if (this.running) break block5;
                try {
                    this.client.createContainers(this.root);
                    this.cache = CuratorCache.builder((CuratorFramework)this.client, (String)this.root).build();
                    this.cache.listenable().addListener((Object)new MetadataStoreCacheListener());
                    this.cache.start();
                    this.running = true;
                }
                catch (Exception ex) {
                    throw new ZookeeperMetadataStoreException("Exception while starting bean", ex);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            if (this.running) {
                if (this.cache != null) {
                    CloseableUtils.closeQuietly((Closeable)this.cache);
                }
                this.cache = null;
                this.running = false;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isRunning() {
        this.lock.lock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getPhase() {
        return this.phase;
    }

    private String getKey(String path) {
        return path.replace(this.root + "/", "");
    }

    private record LocalChildData(String value, int version) {
    }

    private class MetadataStoreCacheListener
    implements CuratorCacheListener {
        MetadataStoreCacheListener() {
        }

        public void event(CuratorCacheListener.Type type, ChildData oldData, ChildData newData) {
            ChildData data = CuratorCacheListener.Type.NODE_DELETED.equals((Object)type) ? oldData : newData;
            String eventPath = data.getPath();
            String eventKey = ZookeeperMetadataStore.this.getKey(eventPath);
            if (ZookeeperMetadataStore.this.root.equals(eventKey)) {
                return;
            }
            String value = IntegrationUtils.bytesToString((byte[])data.getData(), (String)ZookeeperMetadataStore.this.encoding);
            switch (type) {
                case NODE_CREATED: {
                    if (ZookeeperMetadataStore.this.updateMap.containsKey(eventKey) && data.getStat().getVersion() >= ((LocalChildData)ZookeeperMetadataStore.this.updateMap.get(eventKey)).version()) {
                        ZookeeperMetadataStore.this.updateMap.remove(eventPath);
                    }
                    ZookeeperMetadataStore.this.listeners.forEach(listener -> listener.onAdd(eventKey, value));
                    break;
                }
                case NODE_CHANGED: {
                    if (ZookeeperMetadataStore.this.updateMap.containsKey(eventKey) && data.getStat().getVersion() >= ((LocalChildData)ZookeeperMetadataStore.this.updateMap.get(eventKey)).version()) {
                        ZookeeperMetadataStore.this.updateMap.remove(eventPath);
                    }
                    ZookeeperMetadataStore.this.listeners.forEach(listener -> listener.onUpdate(eventKey, value));
                    break;
                }
                case NODE_DELETED: {
                    ZookeeperMetadataStore.this.updateMap.remove(eventKey);
                    ZookeeperMetadataStore.this.listeners.forEach(listener -> listener.onRemove(eventKey, value));
                }
            }
        }
    }
}

