/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.handshake;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.database.protocol.mysql.packet.handshake.MySQLAuthenticationPluginData;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLAuthSwitchRequestPacket
extends MySQLPacket {
    public static final int HEADER = 254;
    private final String authPluginName;
    private final MySQLAuthenticationPluginData authPluginData;

    public MySQLAuthSwitchRequestPacket(MySQLPacketPayload payload) {
        Preconditions.checkArgument((254 == payload.readInt1() ? 1 : 0) != 0, (Object)"Header of MySQL auth switch request packet must be `0xfe`.");
        this.authPluginName = payload.readStringNul();
        String strAuthPluginData = payload.readStringNul();
        this.authPluginData = new MySQLAuthenticationPluginData(Arrays.copyOfRange(strAuthPluginData.getBytes(), 0, 8), Arrays.copyOfRange(strAuthPluginData.getBytes(), 8, 20));
    }

    @Override
    protected void write(MySQLPacketPayload payload) {
        payload.writeInt1(254);
        payload.writeStringNul(this.authPluginName);
        payload.writeStringNul(new String(this.authPluginData.getAuthenticationPluginData()));
    }

    @Generated
    public MySQLAuthSwitchRequestPacket(String authPluginName, MySQLAuthenticationPluginData authPluginData) {
        this.authPluginName = authPluginName;
        this.authPluginData = authPluginData;
    }

    @Generated
    public String getAuthPluginName() {
        return this.authPluginName;
    }

    @Generated
    public MySQLAuthenticationPluginData getAuthPluginData() {
        return this.authPluginData;
    }
}

