/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.oracle.visitor.statement.type;

import java.util.Collections;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OracleStatementParser;
import org.apache.shardingsphere.sql.parser.engine.oracle.visitor.statement.OracleStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.GrantStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.RevokeStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.AlterRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.CreateRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.DropRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.SetRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.user.AlterUserStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.user.CreateUserStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.user.DropUserStatement;

public final class OracleDCLStatementVisitor
extends OracleStatementVisitor
implements DCLStatementVisitor {
    public OracleDCLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitGrant(OracleStatementParser.GrantContext ctx) {
        GrantStatement result = new GrantStatement(this.getDatabaseType());
        if (null != ctx.objectPrivilegeClause() && null != ctx.objectPrivilegeClause().onObjectClause().tableName()) {
            result.getTables().add((SimpleTableSegment)this.visit((ParseTree)ctx.objectPrivilegeClause().onObjectClause().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitRevoke(OracleStatementParser.RevokeContext ctx) {
        RevokeStatement result = new RevokeStatement(this.getDatabaseType());
        if (null != ctx.objectPrivilegeClause() && null != ctx.objectPrivilegeClause().onObjectClause().tableName()) {
            result.getTables().add((SimpleTableSegment)this.visit((ParseTree)ctx.objectPrivilegeClause().onObjectClause().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateUser(OracleStatementParser.CreateUserContext ctx) {
        return new CreateUserStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropUser(OracleStatementParser.DropUserContext ctx) {
        return new DropUserStatement(this.getDatabaseType(), Collections.emptyList());
    }

    @Override
    public ASTNode visitAlterUser(OracleStatementParser.AlterUserContext ctx) {
        return new AlterUserStatement(this.getDatabaseType(), null);
    }

    @Override
    public ASTNode visitCreateRole(OracleStatementParser.CreateRoleContext ctx) {
        return new CreateRoleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterRole(OracleStatementParser.AlterRoleContext ctx) {
        return new AlterRoleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropRole(OracleStatementParser.DropRoleContext ctx) {
        return new DropRoleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitSetRole(OracleStatementParser.SetRoleContext ctx) {
        return new SetRoleStatement(this.getDatabaseType());
    }
}

