/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;

final class CharArrayConversions {
    private CharArrayConversions() {
    }

    static ByteBuffer toByteBuffer(Object from, Converter converter) {
        return converter.getOptions().getCharset().encode(CharArrayConversions.toCharBuffer(from, converter));
    }

    static String toString(Object from, Converter converter) {
        char[] chars = (char[])from;
        return new String(chars);
    }

    static CharBuffer toCharBuffer(Object from, Converter converter) {
        char[] chars = (char[])from;
        return CharBuffer.wrap(chars);
    }

    static StringBuffer toStringBuffer(Object from, Converter converter) {
        return new StringBuffer(CharArrayConversions.toCharBuffer(from, converter));
    }

    static StringBuilder toStringBuilder(Object from, Converter converter) {
        return new StringBuilder(CharArrayConversions.toCharBuffer(from, converter));
    }

    static char[] toCharArray(Object from, Converter converter) {
        char[] chars = (char[])from;
        return Arrays.copyOf(chars, chars.length);
    }
}

