/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.executors;

import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdCreateBlobCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.generic.FirebirdGenericResponsePacket;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.FirebirdBlobIdGenerator;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.upload.FirebirdBlobUploadCache;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement.FirebirdStatementIdGenerator;

public final class FirebirdCreateBlobCommandExecutor
implements CommandExecutor {
    private final FirebirdCreateBlobCommandPacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket> execute() {
        int blobHandle = FirebirdStatementIdGenerator.getInstance().nextStatementId(this.connectionSession.getConnectionId());
        long blobId = FirebirdBlobIdGenerator.getInstance().nextBlobId(this.connectionSession.getConnectionId());
        FirebirdBlobUploadCache.getInstance().registerBlob(this.connectionSession.getConnectionId(), blobHandle, blobId);
        FirebirdGenericResponsePacket response = new FirebirdGenericResponsePacket().setHandle(blobHandle).setId(blobId);
        return Collections.singleton(response);
    }

    @Generated
    public FirebirdCreateBlobCommandExecutor(FirebirdCreateBlobCommandPacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

