/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.hive.jdbcurl;

import java.util.Map;
import java.util.Properties;
import org.apache.hive.jdbc.Utils;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionProperties;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionPropertiesParser;

public final class HiveConnectionPropertiesParser
implements ConnectionPropertiesParser {
    public ConnectionProperties parse(String url, String username, String catalog) {
        Utils.JdbcConnectionParams params = Utils.parseURL((String)url, (Properties)new Properties());
        if (null == params.getHost() && 0 == params.getPort()) {
            throw new RuntimeException("HiveServer2 in embedded mode has been deprecated by Apache Hive, See https://issues.apache.org/jira/browse/HIVE-28418 . Users should start local HiveServer2 through Docker Image https://hub.docker.com/r/apache/hive .");
        }
        Properties queryProps = new Properties();
        queryProps.putAll((Map<?, ?>)params.getSessionVars());
        queryProps.putAll((Map<?, ?>)params.getHiveConfs());
        queryProps.putAll((Map<?, ?>)params.getHiveVars());
        return new ConnectionProperties(params.getHost(), params.getPort(), params.getDbName(), null, queryProps);
    }

    public String getDatabaseType() {
        return "Hive";
    }
}

