/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.consistencycheck;

import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobId;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobType;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.util.ConsistencyCheckSequence;

public final class ConsistencyCheckJobId
implements PipelineJobId {
    private final ConsistencyCheckJobType jobType = new ConsistencyCheckJobType();
    private final PipelineContextKey contextKey;
    private final String parentJobId;
    private final int sequence;

    public ConsistencyCheckJobId(PipelineContextKey contextKey, String parentJobId) {
        this(contextKey, parentJobId, 1);
    }

    public ConsistencyCheckJobId(PipelineContextKey contextKey, String parentJobId, String latestCheckJobId) {
        this(contextKey, parentJobId, ConsistencyCheckSequence.getNextSequence(ConsistencyCheckJobId.parseSequence(latestCheckJobId)));
    }

    public ConsistencyCheckJobId(PipelineContextKey contextKey, String parentJobId, int sequence) {
        this.contextKey = contextKey;
        this.parentJobId = parentJobId;
        this.sequence = sequence > 3 ? 1 : sequence;
    }

    public static int parseSequence(String checkJobId) {
        return Integer.parseInt(checkJobId.substring(checkJobId.length() - 1));
    }

    public String marshalSuffix() {
        return this.parentJobId + this.sequence;
    }

    @Generated
    public ConsistencyCheckJobType getJobType() {
        return this.jobType;
    }

    @Generated
    public PipelineContextKey getContextKey() {
        return this.contextKey;
    }

    @Generated
    public String getParentJobId() {
        return this.parentJobId;
    }

    @Generated
    public int getSequence() {
        return this.sequence;
    }
}

