/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminUpdateExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLKillStatement;

public final class MySQLKillProcessExecutor
implements DatabaseAdminUpdateExecutor {
    private static final String QUERY_SCOPE = "QUERY";
    private final MySQLKillStatement killStatement;

    public void execute(ConnectionSession connectionSession, ShardingSphereMetaData metaData) throws SQLException {
        ShardingSpherePreconditions.checkState((boolean)QUERY_SCOPE.equalsIgnoreCase(this.killStatement.getScope()), () -> new UnsupportedSQLOperationException("Only `KILL QUERY <processId>` SQL syntax is supported"));
        String processId = this.killStatement.getProcessId();
        ProxyContext.getInstance().getContextManager().getPersistServiceFacade().getModeFacade().getProcessService().killProcess(processId);
    }

    @Generated
    public MySQLKillProcessExecutor(MySQLKillStatement killStatement) {
        this.killStatement = killStatement;
    }
}

