/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.connector.sane;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.proxy.backend.connector.sane.DialectSaneQueryResultEngine;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.sysvar.MySQLSystemVariable;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.MySQLShowOtherStatement;

public final class MySQLDialectSaneQueryResultEngine
implements DialectSaneQueryResultEngine {
    private static final int ER_PARSE_ERROR = 1064;

    public Optional<ExecuteResult> getSaneQueryResult(SQLStatement sqlStatement, SQLException ex) {
        if (1064 == ex.getErrorCode()) {
            return Optional.empty();
        }
        if (sqlStatement instanceof SelectStatement) {
            return this.createQueryResult((SelectStatement)sqlStatement);
        }
        if (sqlStatement instanceof MySQLShowOtherStatement) {
            return Optional.of(this.createQueryResult());
        }
        if (sqlStatement instanceof SetStatement) {
            return Optional.of(new UpdateResult(0, 0L));
        }
        return Optional.empty();
    }

    private Optional<ExecuteResult> createQueryResult(SelectStatement sqlStatement) {
        if (sqlStatement.getFrom().isPresent()) {
            return Optional.empty();
        }
        ArrayList<RawQueryResultColumnMetaData> queryResultColumnMetaDataList = new ArrayList<RawQueryResultColumnMetaData>(sqlStatement.getProjections().getProjections().size());
        ArrayList<String> data = new ArrayList<String>(sqlStatement.getProjections().getProjections().size());
        for (ProjectionSegment each : sqlStatement.getProjections().getProjections()) {
            if (!(each instanceof ExpressionProjectionSegment)) continue;
            ExpressionProjectionSegment expressionProjection = (ExpressionProjectionSegment)each;
            String text = expressionProjection.getText();
            String alias = expressionProjection.getAliasName().orElse(expressionProjection.getText());
            queryResultColumnMetaDataList.add(this.createRawQueryResultColumnMetaData(text, alias));
            String value = expressionProjection.getExpr() instanceof VariableSegment ? MySQLSystemVariable.findSystemVariable(((VariableSegment)expressionProjection.getExpr()).getVariable()).map(MySQLSystemVariable::getDefaultValue).orElse("1") : "1";
            data.add(value);
        }
        return queryResultColumnMetaDataList.isEmpty() ? Optional.empty() : Optional.of(new RawMemoryQueryResult((QueryResultMetaData)new RawQueryResultMetaData(queryResultColumnMetaDataList), Collections.singletonList(new MemoryQueryResultDataRow(data))));
    }

    private QueryResult createQueryResult() {
        RawQueryResultColumnMetaData queryResultColumnMetaData = this.createRawQueryResultColumnMetaData("", "");
        MemoryQueryResultDataRow resultDataRow = new MemoryQueryResultDataRow(Collections.singletonList("1"));
        return new RawMemoryQueryResult((QueryResultMetaData)new RawQueryResultMetaData(Collections.singletonList(queryResultColumnMetaData)), Collections.singletonList(resultDataRow));
    }

    private RawQueryResultColumnMetaData createRawQueryResultColumnMetaData(String name, String label) {
        return new RawQueryResultColumnMetaData("", name, label, 12, "VARCHAR", 255, 0);
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

