/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.update;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.type.DatabaseRuleCreateExecutor;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.readwritesplitting.config.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.config.rule.ReadwriteSplittingDataSourceGroupRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.handler.checker.ReadwriteSplittingRuleStatementChecker;
import org.apache.shardingsphere.readwritesplitting.distsql.handler.converter.ReadwriteSplittingRuleStatementConverter;
import org.apache.shardingsphere.readwritesplitting.distsql.segment.ReadwriteSplittingRuleSegment;
import org.apache.shardingsphere.readwritesplitting.distsql.statement.CreateReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;

public final class CreateReadwriteSplittingRuleExecutor
implements DatabaseRuleCreateExecutor<CreateReadwriteSplittingRuleStatement, ReadwriteSplittingRule, ReadwriteSplittingRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ReadwriteSplittingRule rule;

    public void checkBeforeUpdate(CreateReadwriteSplittingRuleStatement sqlStatement) {
        ReadwriteSplittingRuleStatementChecker.checkCreation(this.database, sqlStatement.getRules(), null == this.rule ? null : this.rule.getConfiguration(), sqlStatement.isIfNotExists());
    }

    public ReadwriteSplittingRuleConfiguration buildToBeCreatedRuleConfiguration(CreateReadwriteSplittingRuleStatement sqlStatement) {
        Collection segments = sqlStatement.getRules();
        if (sqlStatement.isIfNotExists()) {
            Collection<String> duplicatedRuleNames = this.getDuplicatedRuleNames(sqlStatement.getRules());
            segments.removeIf(each -> duplicatedRuleNames.contains(each.getName()));
        }
        return ReadwriteSplittingRuleStatementConverter.convert(segments);
    }

    private Collection<String> getDuplicatedRuleNames(Collection<ReadwriteSplittingRuleSegment> segments) {
        LinkedList currentRuleNames = new LinkedList();
        if (null != this.rule) {
            currentRuleNames.addAll(this.rule.getConfiguration().getDataSourceGroups().stream().map(ReadwriteSplittingDataSourceGroupRuleConfiguration::getName).collect(Collectors.toList()));
        }
        return segments.stream().map(ReadwriteSplittingRuleSegment::getName).filter(currentRuleNames::contains).collect(Collectors.toList());
    }

    public Class<ReadwriteSplittingRule> getRuleClass() {
        return ReadwriteSplittingRule.class;
    }

    public Class<CreateReadwriteSplittingRuleStatement> getType() {
        return CreateReadwriteSplittingRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ReadwriteSplittingRule rule) {
        this.rule = rule;
    }
}

