/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.schedule.core.job.statistics.collect;

import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.ScheduleJobBootstrap;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.internal.operate.JobOperateAPIImpl;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.internal.settings.JobConfigurationAPIImpl;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperConfiguration;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperRegistryCenter;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.type.database.statistics.StatisticsJobNodePath;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.schedule.core.job.statistics.collect.StatisticsCollectJob;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatisticsCollectJobWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticsCollectJobWorker.class);
    private static final String JOB_NAME = "statistics-collect";
    private static final AtomicBoolean WORKER_INITIALIZED = new AtomicBoolean(false);
    private static ScheduleJobBootstrap scheduleJobBootstrap;
    private static ContextManager contextManager;
    private static CoordinatorRegistryCenter registryCenter;

    public void initialize(ContextManager contextManager) {
        if (WORKER_INITIALIZED.compareAndSet(false, true)) {
            ModeConfiguration modeConfig = contextManager.getComputeNodeInstanceContext().getModeConfiguration();
            if (!"ZooKeeper".equals(modeConfig.getRepository().getType())) {
                log.warn("Can not collect statistics because of unsupported cluster type: {}", (Object)modeConfig.getRepository().getType());
                return;
            }
            StatisticsCollectJobWorker.contextManager = contextManager;
            registryCenter = this.createRegistryCenter(modeConfig);
            scheduleJobBootstrap = new ScheduleJobBootstrap(registryCenter, (ElasticJob)new StatisticsCollectJob(contextManager), this.createJobConfiguration());
            scheduleJobBootstrap.schedule();
            new JobOperateAPIImpl(registryCenter).trigger(JOB_NAME);
        }
    }

    private CoordinatorRegistryCenter createRegistryCenter(ModeConfiguration modeConfig) {
        ClusterPersistRepositoryConfiguration repositoryConfig = (ClusterPersistRepositoryConfiguration)modeConfig.getRepository();
        String namespace = repositoryConfig.getNamespace() + NodePathGenerator.toPath((NodePath)new StatisticsJobNodePath());
        ZookeeperRegistryCenter result = new ZookeeperRegistryCenter(this.getZookeeperConfiguration(repositoryConfig, namespace));
        result.init();
        return result;
    }

    private ZookeeperConfiguration getZookeeperConfiguration(ClusterPersistRepositoryConfiguration repositoryConfig, String namespace) {
        int operationTimeoutMilliseconds;
        int timeToLiveSeconds;
        ZookeeperConfiguration result = new ZookeeperConfiguration(repositoryConfig.getServerLists(), namespace);
        Properties props = repositoryConfig.getProps();
        int retryIntervalMilliseconds = props.containsKey("retryIntervalMilliseconds") ? Integer.parseInt(props.get("retryIntervalMilliseconds").toString()) : 500;
        int maxRetries = props.containsKey("maxRetries") ? Integer.parseInt(props.get("maxRetries").toString()) : 3;
        result.setBaseSleepTimeMilliseconds(retryIntervalMilliseconds);
        result.setMaxRetries(maxRetries);
        result.setMaxSleepTimeMilliseconds(retryIntervalMilliseconds * maxRetries);
        int n = timeToLiveSeconds = props.containsKey("timeToLiveSeconds") ? Integer.parseInt(props.get("timeToLiveSeconds").toString()) : 60;
        if (0 != timeToLiveSeconds) {
            result.setSessionTimeoutMilliseconds(timeToLiveSeconds * 1000);
        }
        int n2 = operationTimeoutMilliseconds = props.containsKey("operationTimeoutMilliseconds") ? Integer.parseInt(props.get("operationTimeoutMilliseconds").toString()) : 500;
        if (0 != operationTimeoutMilliseconds) {
            result.setConnectionTimeoutMilliseconds(operationTimeoutMilliseconds);
        }
        result.setDigest(props.getProperty("digest"));
        return result;
    }

    private JobConfiguration createJobConfiguration() {
        String jobCron = (String)contextManager.getMetaDataContexts().getMetaData().getTemporaryProps().getValue((Enum)TemporaryConfigurationPropertyKey.PROXY_META_DATA_COLLECTOR_CRON);
        if (!CronExpression.isValidExpression((String)jobCron)) {
            String defaultJobCron = TemporaryConfigurationPropertyKey.PROXY_META_DATA_COLLECTOR_CRON.getDefaultValue();
            log.warn("The value `{}` of `{}` is invalid, default value `{}` will be used", new Object[]{jobCron, TemporaryConfigurationPropertyKey.PROXY_META_DATA_COLLECTOR_CRON.getKey(), defaultJobCron});
            jobCron = defaultJobCron;
        }
        return JobConfiguration.newBuilder((String)JOB_NAME, (int)1).cron(jobCron).overwrite(true).build();
    }

    public void updateJobConfiguration() {
        if (null == contextManager) {
            return;
        }
        String cron = (String)contextManager.getMetaDataContexts().getMetaData().getTemporaryProps().getValue((Enum)TemporaryConfigurationPropertyKey.PROXY_META_DATA_COLLECTOR_CRON);
        log.info("Changing cron of statistics collect job to `{}`", (Object)cron);
        try {
            new JobConfigurationAPIImpl(registryCenter).updateJobConfiguration(JobConfigurationPOJO.fromJobConfiguration((JobConfiguration)this.createJobConfiguration()));
            log.info("Changed cron of statistics collect job to `{}`", (Object)cron);
        }
        catch (Exception ex) {
            log.error("Change statistics collect job cron value error", (Throwable)ex);
        }
    }

    public void destroy() {
        if (WORKER_INITIALIZED.compareAndSet(true, false)) {
            Optional.ofNullable(scheduleJobBootstrap).ifPresent(ScheduleJobBootstrap::shutdown);
            scheduleJobBootstrap = null;
        }
    }

    @Generated
    public StatisticsCollectJobWorker() {
    }
}

