/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.instance;

import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceNode;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceService;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.SchedulerFacade;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEvent;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEventListener;

public final class ShutdownListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final InstanceNode instanceNode;
    private final InstanceService instanceService;
    private final SchedulerFacade schedulerFacade;

    public ShutdownListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.instanceNode = new InstanceNode(jobName);
        this.instanceService = new InstanceService(regCenter, jobName);
        this.schedulerFacade = new SchedulerFacade(regCenter, jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new InstanceShutdownStatusJobListener());
    }

    class InstanceShutdownStatusJobListener
    implements DataChangedEventListener {
        InstanceShutdownStatusJobListener() {
        }

        public void onChange(DataChangedEvent event) {
            if (!JobRegistry.getInstance().isShutdown(ShutdownListenerManager.this.jobName) && !JobRegistry.getInstance().getJobScheduleController(ShutdownListenerManager.this.jobName).isPaused() && this.isRemoveInstance(event.getKey(), event.getType()) && !this.isReconnectedRegistryCenter()) {
                ShutdownListenerManager.this.schedulerFacade.shutdownInstance();
            }
        }

        private boolean isRemoveInstance(String path, DataChangedEvent.Type eventType) {
            return ShutdownListenerManager.this.instanceNode.isLocalInstancePath(path) && DataChangedEvent.Type.DELETED == eventType;
        }

        private boolean isReconnectedRegistryCenter() {
            return ShutdownListenerManager.this.instanceService.isLocalJobInstanceExisted();
        }
    }
}

