/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.tcl.local.type;

import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.util.TransactionUtils;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionAccessType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionIsolationLevel;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SetTransactionStatement;
import org.apache.shardingsphere.transaction.exception.SwitchTypeInTransactionException;

public final class SetTransactionProxyBackendHandler
implements ProxyBackendHandler {
    private final SetTransactionStatement sqlStatement;
    private final ConnectionSession connectionSession;
    private final DialectDatabaseMetaData dialectDatabaseMetaData;

    public SetTransactionProxyBackendHandler(SetTransactionStatement sqlStatement, ConnectionSession connectionSession) {
        this.sqlStatement = sqlStatement;
        this.connectionSession = connectionSession;
        this.dialectDatabaseMetaData = new DatabaseTypeRegistry(connectionSession.getProtocolType()).getDialectDatabaseMetaData();
    }

    @Override
    public ResponseHeader execute() {
        ShardingSpherePreconditions.checkState((this.sqlStatement.containsScope() || !this.connectionSession.getTransactionStatus().isInTransaction() ? 1 : 0) != 0, SwitchTypeInTransactionException::new);
        this.setReadOnly();
        this.setTransactionIsolationLevel();
        return new UpdateResponseHeader((SQLStatement)this.sqlStatement);
    }

    private void setReadOnly() {
        if (this.sqlStatement.isDesiredAccessMode(TransactionAccessType.READ_ONLY)) {
            this.connectionSession.setReadOnly(true);
        } else if (this.sqlStatement.isDesiredAccessMode(TransactionAccessType.READ_WRITE)) {
            this.connectionSession.setReadOnly(false);
        }
    }

    private void setTransactionIsolationLevel() {
        if (!this.sqlStatement.getIsolationLevel().isPresent()) {
            return;
        }
        this.connectionSession.setDefaultIsolationLevel(TransactionUtils.getTransactionIsolationLevel(this.dialectDatabaseMetaData.getTransactionOption().getDefaultIsolationLevel()));
        this.connectionSession.setIsolationLevel((TransactionIsolationLevel)this.sqlStatement.getIsolationLevel().get());
    }
}

