/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.data.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.authority.checker.AuthorityChecker;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.EmptyStorageUnitException;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseProxyConnector;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseProxyConnectorFactory;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.data.DatabaseProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class UnicastDatabaseProxyBackendHandler
implements DatabaseProxyBackendHandler {
    private final QueryContext queryContext;
    private final ContextManager contextManager;
    private final ConnectionSession connectionSession;
    private DatabaseProxyConnector databaseProxyConnector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseHeader execute() throws SQLException {
        String originalDatabaseName = this.connectionSession.getCurrentDatabaseName();
        String unicastDatabaseName = null == originalDatabaseName ? this.getFirstDatabaseName() : originalDatabaseName;
        ShardingSpherePreconditions.checkState((boolean)this.contextManager.getDatabase(unicastDatabaseName).containsDataSource(), () -> new EmptyStorageUnitException(unicastDatabaseName));
        try {
            this.connectionSession.setCurrentDatabaseName(unicastDatabaseName);
            this.databaseProxyConnector = DatabaseProxyConnectorFactory.newInstance(this.queryContext, this.connectionSession.getDatabaseConnectionManager(), false);
            ResponseHeader responseHeader = this.databaseProxyConnector.execute();
            return responseHeader;
        }
        finally {
            this.connectionSession.setCurrentDatabaseName(originalDatabaseName);
        }
    }

    private String getFirstDatabaseName() {
        Collection databaseNames = this.contextManager.getAllDatabaseNames();
        ShardingSpherePreconditions.checkNotEmpty((Collection)databaseNames, NoDatabaseSelectedException::new);
        AuthorityRule authorityRule = (AuthorityRule)this.queryContext.getMetaData().getGlobalRuleMetaData().getSingleRule(AuthorityRule.class);
        Collection storageUnitContainedDatabaseNames = databaseNames.stream().filter(each -> ProxyContext.getInstance().getContextManager().getDatabase(each).containsDataSource()).collect(Collectors.toSet());
        AuthorityChecker authorityChecker = new AuthorityChecker(authorityRule, this.connectionSession.getConnectionContext().getGrantee());
        Collection authorizedDatabases = storageUnitContainedDatabaseNames.stream().filter(arg_0 -> ((AuthorityChecker)authorityChecker).isAuthorized(arg_0)).collect(Collectors.toSet());
        Optional result = authorizedDatabases.isEmpty() ? storageUnitContainedDatabaseNames.stream().findFirst() : authorizedDatabases.stream().findFirst();
        ShardingSpherePreconditions.checkState((boolean)result.isPresent(), EmptyStorageUnitException::new);
        return (String)result.get();
    }

    @Override
    public boolean next() throws SQLException {
        return this.databaseProxyConnector.next();
    }

    @Override
    public QueryResponseRow getRowData() throws SQLException {
        return this.databaseProxyConnector.getRowData();
    }

    @Override
    public void close() throws SQLException {
        if (null != this.databaseProxyConnector) {
            this.databaseProxyConnector.close();
        }
    }

    @Generated
    public UnicastDatabaseProxyBackendHandler(QueryContext queryContext, ContextManager contextManager, ConnectionSession connectionSession) {
        this.queryContext = queryContext;
        this.contextManager = contextManager;
        this.connectionSession = connectionSession;
    }
}

