/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.bind;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.postgresql.constant.PostgreSQLValueFormat;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.PostgreSQLColumnType;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.extended.bind.protocol.PostgreSQLBinaryProtocolValueFactory;
import org.apache.shardingsphere.database.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;
import org.apache.shardingsphere.database.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLComBindPacket
extends PostgreSQLCommandPacket {
    private final PostgreSQLPacketPayload payload;
    private final String portal;
    private final String statementId;

    public PostgreSQLComBindPacket(PostgreSQLPacketPayload payload) {
        this.payload = payload;
        payload.readInt4();
        this.portal = payload.readStringNul();
        this.statementId = payload.readStringNul();
    }

    public List<Object> readParameters(List<PostgreSQLColumnType> paramTypes) {
        List<Integer> paramFormats = this.getParameterFormats();
        int parameterCount = this.payload.readInt2();
        ArrayList<Object> result = new ArrayList<Object>(parameterCount);
        for (int paramIndex = 0; paramIndex < parameterCount; ++paramIndex) {
            int parameterValueLength = this.payload.readInt4();
            if (-1 == parameterValueLength) {
                result.add(null);
                continue;
            }
            Object paramValue = this.isTextParameterValue(paramFormats, paramIndex) ? this.getTextParameterValue(this.payload, parameterValueLength, paramTypes.get(paramIndex)) : this.getBinaryParameterValue(this.payload, parameterValueLength, paramTypes.get(paramIndex));
            result.add(paramValue);
        }
        return result;
    }

    private List<Integer> getParameterFormats() {
        int parameterFormatCount = this.payload.readInt2();
        ArrayList<Integer> result = new ArrayList<Integer>(parameterFormatCount);
        for (int i = 0; i < parameterFormatCount; ++i) {
            result.add(this.payload.readInt2());
        }
        return result;
    }

    private boolean isTextParameterValue(List<Integer> paramFormats, int paramIndex) {
        if (paramFormats.isEmpty()) {
            return true;
        }
        return PostgreSQLValueFormat.TEXT.getCode() == paramFormats.get(1 == paramFormats.size() ? 0 : paramIndex).intValue();
    }

    private Object getTextParameterValue(PostgreSQLPacketPayload payload, int paramValueLength, PostgreSQLColumnType paramType) {
        String value = payload.getByteBuf().readCharSequence(paramValueLength, payload.getCharset()).toString();
        return paramType.getTextValueParser().parse(value);
    }

    private Object getBinaryParameterValue(PostgreSQLPacketPayload payload, int paramValueLength, PostgreSQLColumnType paramType) {
        PostgreSQLBinaryProtocolValue binaryProtocolValue = PostgreSQLBinaryProtocolValueFactory.getBinaryProtocolValue(paramType);
        return binaryProtocolValue.read(payload, paramValueLength);
    }

    public List<PostgreSQLValueFormat> readResultFormats() {
        int resultFormatsLength = this.payload.readInt2();
        if (0 == resultFormatsLength) {
            return Collections.emptyList();
        }
        if (1 == resultFormatsLength) {
            return Collections.singletonList(PostgreSQLValueFormat.valueOf(this.payload.readInt2()));
        }
        ArrayList<PostgreSQLValueFormat> result = new ArrayList<PostgreSQLValueFormat>(resultFormatsLength);
        for (int i = 0; i < resultFormatsLength; ++i) {
            result.add(PostgreSQLValueFormat.valueOf(this.payload.readInt2()));
        }
        return result;
    }

    @Override
    protected void write(PostgreSQLPacketPayload payload) {
    }

    @Override
    public PostgreSQLIdentifierTag getIdentifier() {
        return PostgreSQLCommandPacketType.BIND_COMMAND;
    }

    @Generated
    public String getPortal() {
        return this.portal;
    }

    @Generated
    public String getStatementId() {
        return this.statementId;
    }
}

