/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal;

import java.lang.reflect.Field;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.AbstractStringEncoder;
import sun.misc.Unsafe;

final class UnsafeStringEncoder
extends AbstractStringEncoder {
    private final long valueOffset;
    private final long coderOffset;
    private final long byteArrayBaseOffset;

    private UnsafeStringEncoder(long valueOffset, long coderOffset, long byteArrayBaseOffset) {
        this.valueOffset = valueOffset;
        this.coderOffset = coderOffset;
        this.byteArrayBaseOffset = byteArrayBaseOffset;
    }

    @Nullable
    public static UnsafeStringEncoder createIfAvailable() {
        if (UnsafeHolder.UNSAFE == null) {
            return null;
        }
        long valueOffset = UnsafeStringEncoder.getStringFieldOffset("value", byte[].class);
        long coderOffset = UnsafeStringEncoder.getStringFieldOffset("coder", Byte.TYPE);
        if (valueOffset == -1L || coderOffset == -1L) {
            return null;
        }
        long byteArrayBaseOffset = UnsafeHolder.UNSAFE.arrayBaseOffset(byte[].class);
        return new UnsafeStringEncoder(valueOffset, coderOffset, byteArrayBaseOffset);
    }

    @Override
    protected byte[] getStringBytes(String string) {
        return (byte[])UnsafeHolder.UNSAFE.getObject(string, this.valueOffset);
    }

    @Override
    protected boolean isLatin1(String string) {
        return UnsafeHolder.UNSAFE.getByte(string, this.coderOffset) == 0;
    }

    @Override
    protected long getLong(byte[] bytes, int offset) {
        return UnsafeHolder.UNSAFE.getLong(bytes, this.byteArrayBaseOffset + (long)offset);
    }

    private static long getStringFieldOffset(String fieldName, Class<?> expectedType) {
        try {
            if (UnsafeHolder.UNSAFE == null) {
                return -1L;
            }
            Field field = String.class.getDeclaredField(fieldName);
            if (!expectedType.isAssignableFrom(field.getType())) {
                return -1L;
            }
            return UnsafeHolder.UNSAFE.objectFieldOffset(field);
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    private static final class UnsafeHolder {
        private static final Unsafe UNSAFE = UnsafeHolder.getUnsafe();

        private UnsafeHolder() {
        }

        private static Unsafe getUnsafe() {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (Throwable t) {
                return null;
            }
        }
    }
}

