/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal;

import java.util.Locale;
import java.util.function.Consumer;
import org.apache.shardingsphere.shade.io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.Aggregation;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.InstrumentType;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.AggregationUtil;

public final class IncubatingExporterBuilderUtil {
    public static void configureExporterMemoryMode(DeclarativeConfigProperties config, Consumer<MemoryMode> memoryModeConsumer) {
        MemoryMode memoryMode;
        String memoryModeStr = config.getString("memory_mode");
        if (memoryModeStr == null) {
            return;
        }
        try {
            memoryMode = MemoryMode.valueOf(memoryModeStr.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Unrecognized memory_mode: " + memoryModeStr, e);
        }
        memoryModeConsumer.accept(memoryMode);
    }

    public static void configureOtlpAggregationTemporality(DeclarativeConfigProperties config, Consumer<AggregationTemporalitySelector> aggregationTemporalitySelectorConsumer) {
        AggregationTemporalitySelector temporalitySelector;
        String temporalityStr = config.getString("temporality_preference");
        if (temporalityStr == null) {
            return;
        }
        switch (temporalityStr.toLowerCase(Locale.ROOT)) {
            case "cumulative": {
                temporalitySelector = AggregationTemporalitySelector.alwaysCumulative();
                break;
            }
            case "delta": {
                temporalitySelector = AggregationTemporalitySelector.deltaPreferred();
                break;
            }
            case "low_memory": {
                temporalitySelector = AggregationTemporalitySelector.lowMemory();
                break;
            }
            default: {
                throw new ConfigurationException("Unrecognized temporality_preference: " + temporalityStr);
            }
        }
        aggregationTemporalitySelectorConsumer.accept(temporalitySelector);
    }

    public static void configureOtlpHistogramDefaultAggregation(DeclarativeConfigProperties config, Consumer<DefaultAggregationSelector> defaultAggregationSelectorConsumer) {
        String defaultHistogramAggregation = config.getString("default_histogram_aggregation");
        if (defaultHistogramAggregation == null) {
            return;
        }
        if (AggregationUtil.aggregationName(Aggregation.base2ExponentialBucketHistogram()).equalsIgnoreCase(defaultHistogramAggregation)) {
            defaultAggregationSelectorConsumer.accept(DefaultAggregationSelector.getDefault().with(InstrumentType.HISTOGRAM, Aggregation.base2ExponentialBucketHistogram()));
        } else if (!AggregationUtil.aggregationName(Aggregation.explicitBucketHistogram()).equalsIgnoreCase(defaultHistogramAggregation)) {
            throw new ConfigurationException("Unrecognized default_histogram_aggregation: " + defaultHistogramAggregation);
        }
    }

    private IncubatingExporterBuilderUtil() {
    }
}

