/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator.position;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.Range;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.UniqueKeyIngestPosition;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator.InventoryDataSparsenessCalculator;
import org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator.position.estimated.InventoryPositionEstimatedCalculator;
import org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator.position.exact.BinaryPositionHandler;
import org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator.position.exact.IntegerPositionHandler;
import org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator.position.exact.InventoryPositionExactCalculator;
import org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator.position.exact.StringPositionHandler;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.datatype.DialectDataTypeOption;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InventoryPositionCalculator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryPositionCalculator.class);
    private final PipelineDataSource dataSource;
    private final QualifiedTable qualifiedTable;
    private final List<PipelineColumnMetaData> uniqueKeyColumns;
    private final long tableRecordsCount;
    private final int shardingSize;

    public List<IngestPosition> getPositions() {
        int firstColumnDataType;
        DialectDataTypeOption dataTypeOption = new DatabaseTypeRegistry(this.dataSource.getDatabaseType()).getDialectDatabaseMetaData().getDataTypeOption();
        if (dataTypeOption.isIntegerDataType(firstColumnDataType = this.uniqueKeyColumns.get(0).getDataType())) {
            return this.getIntegerPositions();
        }
        if (dataTypeOption.isStringDataType(firstColumnDataType)) {
            return this.getStringPositions();
        }
        if (dataTypeOption.isBinaryDataType(firstColumnDataType)) {
            return this.getBinaryPositions();
        }
        log.info("Unsupported unique key type, unique key columns: {}", this.uniqueKeyColumns);
        return Collections.singletonList(UniqueKeyIngestPosition.ofUnsplit());
    }

    private List<IngestPosition> getIntegerPositions() {
        String uniqueKey = this.uniqueKeyColumns.get(0).getName();
        Range<BigInteger> uniqueKeyValuesRange = InventoryPositionEstimatedCalculator.getIntegerUniqueKeyValuesRange(this.qualifiedTable, uniqueKey, this.dataSource);
        if (InventoryDataSparsenessCalculator.isIntegerUniqueKeyDataSparse(this.tableRecordsCount, uniqueKeyValuesRange)) {
            return InventoryPositionExactCalculator.getPositions(this.qualifiedTable, uniqueKey, this.shardingSize, this.dataSource, new IntegerPositionHandler());
        }
        return InventoryPositionEstimatedCalculator.getIntegerPositions(this.tableRecordsCount, uniqueKeyValuesRange, this.shardingSize);
    }

    private List<IngestPosition> getStringPositions() {
        String uniqueKey = this.uniqueKeyColumns.get(0).getName();
        return InventoryPositionExactCalculator.getPositions(this.qualifiedTable, uniqueKey, this.shardingSize, this.dataSource, new StringPositionHandler());
    }

    private List<IngestPosition> getBinaryPositions() {
        String uniqueKey = this.uniqueKeyColumns.get(0).getName();
        return InventoryPositionExactCalculator.getPositions(this.qualifiedTable, uniqueKey, this.shardingSize, this.dataSource, new BinaryPositionHandler());
    }

    @Generated
    public InventoryPositionCalculator(PipelineDataSource dataSource, QualifiedTable qualifiedTable, List<PipelineColumnMetaData> uniqueKeyColumns, long tableRecordsCount, int shardingSize) {
        this.dataSource = dataSource;
        this.qualifiedTable = qualifiedTable;
        this.uniqueKeyColumns = uniqueKeyColumns;
        this.tableRecordsCount = tableRecordsCount;
        this.shardingSize = shardingSize;
    }
}

