/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator.TableInventoryCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableInventoryCalculator<S>
implements TableInventoryCalculator<S> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTableInventoryCalculator.class);
    private final AtomicBoolean canceling = new AtomicBoolean(false);
    private final AtomicReference<Statement> currentStatement = new AtomicReference();

    protected final void setCurrentStatement(Statement statement) {
        this.currentStatement.set(statement);
    }

    @Override
    public void cancel() {
        this.canceling.set(true);
        Statement statement = this.currentStatement.get();
        if (null == statement || statement.isClosed()) {
            log.info("cancel, statement is null or closed");
            return;
        }
        try {
            statement.cancel();
        }
        catch (SQLFeatureNotSupportedException ex) {
            log.info("cancel is not supported: {}", (Object)ex.getMessage());
        }
        catch (RuntimeException | SQLException ex) {
            log.info("cancel failed: {}", (Object)ex.getMessage());
        }
    }

    @Override
    public final boolean isCanceling() {
        return this.canceling.get();
    }
}

