/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.value.identifier;

import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.ValueASTNode;

public final class IdentifierValue
implements ValueASTNode<String> {
    private final String value;
    private final QuoteCharacter quoteCharacter;

    public IdentifierValue(String text) {
        this.quoteCharacter = QuoteCharacter.getQuoteCharacter((String)text);
        this.value = QuoteCharacter.BACK_QUOTE == this.quoteCharacter ? SQLUtils.getRealContentInBackticks(text) : (null == text ? null : this.quoteCharacter.unwrap(text));
    }

    public String getValueWithQuoteCharacters() {
        return null == this.value ? "" : this.quoteCharacter.wrap(this.value);
    }

    @Generated
    public IdentifierValue(String value, QuoteCharacter quoteCharacter) {
        this.value = value;
        this.quoteCharacter = quoteCharacter;
    }

    @Override
    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public QuoteCharacter getQuoteCharacter() {
        return this.quoteCharacter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdentifierValue)) {
            return false;
        }
        IdentifierValue other = (IdentifierValue)o;
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        QuoteCharacter this$quoteCharacter = this.getQuoteCharacter();
        QuoteCharacter other$quoteCharacter = other.getQuoteCharacter();
        return !(this$quoteCharacter == null ? other$quoteCharacter != null : !this$quoteCharacter.equals(other$quoteCharacter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        QuoteCharacter $quoteCharacter = this.getQuoteCharacter();
        result = result * 59 + ($quoteCharacter == null ? 43 : $quoteCharacter.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IdentifierValue(value=" + this.getValue() + ", quoteCharacter=" + this.getQuoteCharacter() + ")";
    }
}

