/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.rule;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.rule.PartialRuleUpdateSupported;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttributes;
import org.apache.shardingsphere.infra.rule.scope.DatabaseRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mask.config.MaskRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.rule.MaskTable;
import org.apache.shardingsphere.mask.rule.attribute.MaskTableMapperRuleAttribute;
import org.apache.shardingsphere.mask.spi.MaskAlgorithm;

public final class MaskRule
implements DatabaseRule,
PartialRuleUpdateSupported<MaskRuleConfiguration> {
    private final AtomicReference<MaskRuleConfiguration> configuration = new AtomicReference();
    private final Map<String, MaskAlgorithm<?, ?>> maskAlgorithms = new CaseInsensitiveMap(Collections.emptyMap(), new ConcurrentHashMap());
    private final Map<String, MaskTable> tables = new CaseInsensitiveMap(Collections.emptyMap(), new ConcurrentHashMap());
    private final AtomicReference<RuleAttributes> attributes = new AtomicReference();

    public MaskRule(MaskRuleConfiguration ruleConfig) {
        this.configuration.set(ruleConfig);
        ruleConfig.getMaskAlgorithms().forEach((key, value) -> this.maskAlgorithms.put((String)key, (MaskAlgorithm<?, ?>)((MaskAlgorithm)TypedSPILoader.getService(MaskAlgorithm.class, (Object)value.getType(), (Properties)value.getProps()))));
        ruleConfig.getTables().forEach(each -> this.tables.put(each.getName(), new MaskTable((MaskTableRuleConfiguration)each, this.maskAlgorithms)));
        this.attributes.set(new RuleAttributes(new RuleAttribute[]{new MaskTableMapperRuleAttribute(this.tables.keySet())}));
    }

    public Optional<MaskTable> findMaskTable(String tableName) {
        return Optional.ofNullable(this.tables.get(tableName));
    }

    public RuleAttributes getAttributes() {
        return this.attributes.get();
    }

    public MaskRuleConfiguration getConfiguration() {
        return this.configuration.get();
    }

    public void updateConfiguration(MaskRuleConfiguration toBeUpdatedRuleConfig) {
        this.configuration.set(toBeUpdatedRuleConfig);
    }

    public boolean partialUpdate(MaskRuleConfiguration toBeUpdatedRuleConfig) {
        this.handleAddedMaskAlgorithm(toBeUpdatedRuleConfig);
        this.handleRemovedMaskAlgorithm(toBeUpdatedRuleConfig);
        Collection toBeUpdatedTablesNames = (Collection)toBeUpdatedRuleConfig.getTables().stream().map(MaskTableRuleConfiguration::getName).collect(Collectors.toCollection(CaseInsensitiveSet::new));
        Collection toBeRemovedTableNames = this.tables.keySet().stream().filter(each -> !toBeUpdatedTablesNames.contains(each)).collect(Collectors.toList());
        if (!toBeRemovedTableNames.isEmpty()) {
            toBeRemovedTableNames.forEach(this.tables::remove);
        }
        for (MaskTableRuleConfiguration maskTableRuleConfiguration : toBeUpdatedRuleConfig.getTables()) {
            this.tables.put(maskTableRuleConfiguration.getName(), new MaskTable(maskTableRuleConfiguration, this.maskAlgorithms));
            this.attributes.set(new RuleAttributes(new RuleAttribute[]{new MaskTableMapperRuleAttribute(this.tables.keySet())}));
        }
        return false;
    }

    private void handleAddedMaskAlgorithm(MaskRuleConfiguration toBeUpdatedRuleConfig) {
        toBeUpdatedRuleConfig.getMaskAlgorithms().entrySet().stream().filter(entry -> !this.maskAlgorithms.containsKey(entry.getKey())).forEach(entry -> this.maskAlgorithms.computeIfAbsent((String)entry.getKey(), key -> (MaskAlgorithm)TypedSPILoader.getService(MaskAlgorithm.class, (Object)((AlgorithmConfiguration)entry.getValue()).getType(), (Properties)((AlgorithmConfiguration)entry.getValue()).getProps())));
    }

    private void handleRemovedMaskAlgorithm(MaskRuleConfiguration toBeUpdatedRuleConfig) {
        this.maskAlgorithms.entrySet().stream().filter(entry -> !toBeUpdatedRuleConfig.getMaskAlgorithms().containsKey(entry.getKey())).forEach(entry -> this.maskAlgorithms.remove(entry.getKey()));
    }

    public int getOrder() {
        return 30;
    }
}

