/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.data.unsigned;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.data.unsigned.MySQLBinlogUnsignedNumberHandler;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.data.unsigned.impl.MySQLBinlogUnsignedBigintHandler;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.data.unsigned.impl.MySQLBinlogUnsignedIntHandler;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.data.unsigned.impl.MySQLBinlogUnsignedMediumintHandler;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.data.unsigned.impl.MySQLBinlogUnsignedSmallintHandler;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.data.unsigned.impl.MySQLBinlogUnsignedTinyintHandler;

public final class MySQLBinlogUnsignedNumberHandlerEngine {
    private static final Map<String, MySQLBinlogUnsignedNumberHandler> HANDLERS = new HashMap<String, MySQLBinlogUnsignedNumberHandler>();

    public static Optional<Serializable> handle(PipelineColumnMetaData columnMetaData, Serializable value) {
        String dataTypeName = columnMetaData.getDataTypeName();
        return HANDLERS.containsKey(dataTypeName) ? Optional.of(HANDLERS.get(dataTypeName).handle(value)) : Optional.empty();
    }

    @Generated
    private MySQLBinlogUnsignedNumberHandlerEngine() {
    }

    static {
        HANDLERS.put("TINYINT UNSIGNED", new MySQLBinlogUnsignedTinyintHandler());
        HANDLERS.put("SMALLINT UNSIGNED", new MySQLBinlogUnsignedSmallintHandler());
        HANDLERS.put("MEDIUMINT UNSIGNED", new MySQLBinlogUnsignedMediumintHandler());
        HANDLERS.put("INT UNSIGNED", new MySQLBinlogUnsignedIntHandler());
        HANDLERS.put("BIGINT UNSIGNED", new MySQLBinlogUnsignedBigintHandler());
    }
}

