/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.persist;

import lombok.Generated;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.metadata.manager.MetaDataContextManager;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistFacade;
import org.apache.shardingsphere.mode.node.QualifiedDataSourceStatePersistService;
import org.apache.shardingsphere.mode.persist.mode.ModePersistServiceFacade;
import org.apache.shardingsphere.mode.persist.mode.ModePersistServiceFacadeBuilder;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;
import org.apache.shardingsphere.mode.state.StatePersistService;

public final class PersistServiceFacade
implements AutoCloseable {
    private final PersistRepository repository;
    private final MetaDataPersistFacade metaDataFacade;
    private final StatePersistService stateService;
    private final QualifiedDataSourceStatePersistService qualifiedDataSourceStateService;
    private final ModePersistServiceFacade modeFacade;

    public PersistServiceFacade(PersistRepository repository, ModeConfiguration modeConfig, MetaDataContextManager metaDataContextManager) {
        this.repository = repository;
        this.metaDataFacade = new MetaDataPersistFacade(repository, (Boolean)metaDataContextManager.getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PERSIST_SCHEMAS_TO_REPOSITORY_ENABLED));
        this.stateService = new StatePersistService(repository);
        this.qualifiedDataSourceStateService = new QualifiedDataSourceStatePersistService(repository);
        this.modeFacade = ((ModePersistServiceFacadeBuilder)TypedSPILoader.getService(ModePersistServiceFacadeBuilder.class, (Object)modeConfig.getType())).build(metaDataContextManager, repository);
    }

    @Override
    public void close() {
        this.modeFacade.close();
        this.repository.close();
    }

    @Generated
    public PersistRepository getRepository() {
        return this.repository;
    }

    @Generated
    public MetaDataPersistFacade getMetaDataFacade() {
        return this.metaDataFacade;
    }

    @Generated
    public StatePersistService getStateService() {
        return this.stateService;
    }

    @Generated
    public QualifiedDataSourceStatePersistService getQualifiedDataSourceStateService() {
        return this.qualifiedDataSourceStateService;
    }

    @Generated
    public ModePersistServiceFacade getModeFacade() {
        return this.modeFacade;
    }
}

