/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.resource;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.jdbcurl.judger.DatabaseInstanceJudgeEngine;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionProperties;
import org.apache.shardingsphere.infra.datasource.pool.props.creator.DataSourcePoolPropertiesCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNodeAggregator;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;

public final class ResourceMetaData {
    private final Map<StorageNode, DataSource> dataSources;
    private final Map<String, StorageUnit> storageUnits;

    public ResourceMetaData(Map<String, DataSource> dataSources) {
        this.dataSources = StorageNodeAggregator.aggregateDataSources(dataSources);
        Map storageUnitNodeMap = dataSources.keySet().stream().collect(Collectors.toMap(each -> each, StorageNode::new, (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        Map dataSourcePoolPropsMap = dataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourcePoolPropertiesCreator.create((DataSource)((DataSource)entry.getValue())), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        this.storageUnits = storageUnitNodeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new StorageUnit((StorageNode)entry.getValue(), (DataSourcePoolProperties)dataSourcePoolPropsMap.get(entry.getKey()), (DataSource)dataSources.get(((StorageNode)entry.getValue()).getName())), (oldValue, currentValue) -> currentValue, LinkedHashMap::new));
    }

    public Collection<String> getAllInstanceDataSourceNames() {
        LinkedList<String> result = new LinkedList<String>();
        for (String each : this.storageUnits.keySet()) {
            if (this.isExisted(each, result)) continue;
            result.add(each);
        }
        return result;
    }

    private boolean isExisted(String dataSourceName, Collection<String> existedDataSourceNames) {
        DatabaseInstanceJudgeEngine judgeEngine = new DatabaseInstanceJudgeEngine(this.storageUnits.get(dataSourceName).getStorageType());
        ConnectionProperties connectionProps = this.storageUnits.get(dataSourceName).getConnectionProperties();
        return existedDataSourceNames.stream().anyMatch(each -> judgeEngine.isInSameDatabaseInstance(connectionProps, this.storageUnits.get(each).getConnectionProperties()));
    }

    public Collection<String> getNotExistedDataSources(Collection<String> resourceNames) {
        return resourceNames.stream().filter(each -> !this.storageUnits.containsKey(each)).collect(Collectors.toSet());
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.storageUnits.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSource(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    @Generated
    public ResourceMetaData(Map<StorageNode, DataSource> dataSources, Map<String, StorageUnit> storageUnits) {
        this.dataSources = dataSources;
        this.storageUnits = storageUnits;
    }

    @Generated
    public Map<StorageNode, DataSource> getDataSources() {
        return this.dataSources;
    }

    @Generated
    public Map<String, StorageUnit> getStorageUnits() {
        return this.storageUnits;
    }
}

