/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.core.task;

import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteCallback;
import org.apache.shardingsphere.data.pipeline.core.execute.PipelineExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.execute.PipelineLifecycleRunnable;
import org.apache.shardingsphere.data.pipeline.core.importer.Importer;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.Dumper;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTask;
import org.apache.shardingsphere.data.pipeline.core.task.TaskExecuteCallback;
import org.apache.shardingsphere.data.pipeline.core.task.progress.IncrementalTaskProgress;
import org.jspecify.annotations.Nullable;

public final class CDCIncrementalTask
implements PipelineTask {
    private final String taskId;
    private final PipelineExecuteEngine incrementalExecuteEngine;
    private final Dumper dumper;
    private final @Nullable Importer importer;
    private final IncrementalTaskProgress taskProgress;

    public Collection<CompletableFuture<?>> start() {
        this.taskProgress.getIncrementalTaskDelay().setLatestActiveTimeMillis(System.currentTimeMillis());
        LinkedList result = new LinkedList();
        result.add(this.incrementalExecuteEngine.submit((PipelineLifecycleRunnable)this.dumper, (ExecuteCallback)new TaskExecuteCallback((PipelineTask)this)));
        if (null != this.importer) {
            result.add(this.incrementalExecuteEngine.submit((PipelineLifecycleRunnable)this.importer, (ExecuteCallback)new TaskExecuteCallback((PipelineTask)this)));
        }
        return result;
    }

    public void stop() {
        this.dumper.stop();
        if (null != this.importer) {
            this.importer.stop();
        }
    }

    @Generated
    public CDCIncrementalTask(String taskId, PipelineExecuteEngine incrementalExecuteEngine, Dumper dumper, @Nullable Importer importer, IncrementalTaskProgress taskProgress) {
        this.taskId = taskId;
        this.incrementalExecuteEngine = incrementalExecuteEngine;
        this.dumper = dumper;
        this.importer = importer;
        this.taskProgress = taskProgress;
    }

    @Generated
    public String toString() {
        return "CDCIncrementalTask(taskId=" + this.getTaskId() + ")";
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public IncrementalTaskProgress getTaskProgress() {
        return this.taskProgress;
    }
}

