/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.expr.groovy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import groovy.util.Expando;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.expr.core.GroovyUtils;
import org.apache.shardingsphere.infra.expr.spi.InlineExpressionParser;

public final class GroovyInlineExpressionParser
implements InlineExpressionParser {
    private static final String INLINE_EXPRESSION_KEY = "inlineExpression";
    private static final GroovyShell SHELL = new GroovyShell();
    private static volatile long currentCacheSize = Long.parseLong(ConfigurationPropertyKey.GROOVY_INLINE_EXPRESSION_PARSING_CACHE_MAX_SIZE.getDefaultValue());
    private static volatile Cache<String, Script> scriptCache = Caffeine.newBuilder().maximumSize(currentCacheSize).softValues().build();
    private String inlineExpression;

    public void init(Properties props) {
        this.inlineExpression = props.getProperty(INLINE_EXPRESSION_KEY);
        long maxCacheSize = (Long)new ConfigurationProperties(props).getValue((Enum)ConfigurationPropertyKey.GROOVY_INLINE_EXPRESSION_PARSING_CACHE_MAX_SIZE);
        GroovyInlineExpressionParser.updateMaxCacheSize(maxCacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateMaxCacheSize(long newMaxCacheSize) {
        if (newMaxCacheSize == currentCacheSize) {
            return;
        }
        Class<GroovyInlineExpressionParser> clazz = GroovyInlineExpressionParser.class;
        synchronized (GroovyInlineExpressionParser.class) {
            if (newMaxCacheSize != currentCacheSize) {
                scriptCache = Caffeine.newBuilder().maximumSize(newMaxCacheSize).softValues().build();
                currentCacheSize = newMaxCacheSize;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    public String handlePlaceHolder() {
        return this.handlePlaceHolder(this.inlineExpression);
    }

    private String handlePlaceHolder(String inlineExpression) {
        return inlineExpression.contains("$->{") ? inlineExpression.replaceAll("\\$->\\{", "\\${") : inlineExpression;
    }

    public List<String> splitAndEvaluate() {
        if (Strings.isNullOrEmpty((String)this.inlineExpression)) {
            return Collections.emptyList();
        }
        if (this.isConstantExpression(this.inlineExpression)) {
            return Arrays.stream(this.inlineExpression.split("\\s*,\\s*")).map(String::trim).filter(each -> !each.isEmpty()).collect(Collectors.toList());
        }
        return this.flatten(this.evaluate(GroovyUtils.split((String)this.handlePlaceHolder(this.inlineExpression))));
    }

    public String evaluateWithArgs(Map<String, Comparable<?>> map) {
        if (this.isConstantExpression(this.inlineExpression)) {
            return this.inlineExpression;
        }
        Object scriptResult = this.evaluate("{it -> \"" + this.handlePlaceHolder(this.inlineExpression) + "\"}");
        if (scriptResult instanceof Closure) {
            Closure result = ((Closure)scriptResult).rehydrate((Object)new Expando(), null, null);
            result.setResolveStrategy(3);
            map.forEach((arg_0, arg_1) -> ((Closure)result).setProperty(arg_0, arg_1));
            return result.call().toString();
        }
        return scriptResult.toString();
    }

    private List<Object> evaluate(List<String> inlineExpressions) {
        ArrayList<Object> result = new ArrayList<Object>(inlineExpressions.size());
        for (String each : inlineExpressions) {
            StringBuilder expression = new StringBuilder(this.handlePlaceHolder(each));
            if (!each.startsWith("\"")) {
                expression.insert(0, '\"');
            }
            if (!each.endsWith("\"")) {
                expression.append('\"');
            }
            result.add(this.evaluate(expression.toString()));
        }
        return result;
    }

    private Object evaluate(String expression) {
        if (this.isConstantExpression(expression)) {
            return expression.replaceAll("^\"|\"$", "");
        }
        Script script = (Script)scriptCache.get((Object)expression, arg_0 -> ((GroovyShell)SHELL).parse(arg_0));
        return null == script ? expression : script.run();
    }

    private boolean isConstantExpression(String expression) {
        return Strings.isNullOrEmpty((String)expression) || !this.isDynamicExpression(expression);
    }

    private boolean isDynamicExpression(String expression) {
        return expression.contains("${") || expression.contains("$->{");
    }

    private List<String> flatten(List<Object> segments) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object each : segments) {
            if (each instanceof GString) {
                result.addAll(this.assemblyCartesianSegments((GString)each));
                continue;
            }
            if (each instanceof Script) {
                result.addAll(this.flattenScript((Script)each));
                continue;
            }
            result.add(each.toString());
        }
        return result;
    }

    private List<String> assemblyCartesianSegments(GString segment) {
        Set<List<String>> cartesianValues = this.getCartesianValues(segment);
        ArrayList<String> result = new ArrayList<String>(cartesianValues.size());
        for (List<String> each : cartesianValues) {
            result.add(this.assemblySegment(each, segment));
        }
        return result;
    }

    private Set<List<String>> getCartesianValues(GString segment) {
        ArrayList<Set> result = new ArrayList<Set>(segment.getValues().length);
        for (Object each : segment.getValues()) {
            if (null == each) continue;
            if (each instanceof Collection) {
                result.add(((Collection)each).stream().map(Object::toString).collect(Collectors.toCollection(LinkedHashSet::new)));
                continue;
            }
            result.add(Sets.newHashSet((Object[])new String[]{each.toString()}));
        }
        return Sets.cartesianProduct(result);
    }

    private String assemblySegment(List<String> cartesianValue, GString segment) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < segment.getStrings().length; ++i) {
            result.append(segment.getStrings()[i]);
            if (i >= cartesianValue.size()) continue;
            result.append(cartesianValue.get(i));
        }
        return result.toString();
    }

    private Collection<String> flattenScript(Script script) {
        LinkedList<String> result = new LinkedList<String>();
        Object scriptResult = script.run();
        if (scriptResult instanceof Iterable) {
            for (Object item : (Iterable)scriptResult) {
                result.add(item.toString());
            }
        } else {
            result.add(scriptResult.toString());
        }
        return result;
    }

    public String getType() {
        return "GROOVY";
    }
}

