/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.close;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.external.sql.type.wrapper.SQLWrapperException;

public final class DataSourcesCloser {
    public static void close(Collection<DataSource> dataSources) {
        LinkedList<Exception> causes = new LinkedList<Exception>();
        for (DataSource each : dataSources) {
            if (!(each instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)((Object)each)).close();
            }
            catch (Exception ex) {
                causes.add(ex);
            }
        }
        if (!causes.isEmpty()) {
            DataSourcesCloser.throwException(causes);
        }
    }

    private static void throwException(Collection<Exception> causes) {
        SQLException sqlException = new SQLException("");
        for (Exception each : causes) {
            sqlException.setNextException(new SQLException(each));
        }
        throw new SQLWrapperException(sqlException);
    }

    @Generated
    private DataSourcesCloser() {
    }
}

