/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.sql.type;

import lombok.Generated;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;

public final class SQLFederationDataTypeBuilder {
    public static RelDataType build(ShardingSphereTable table, DatabaseType protocolType, RelDataTypeFactory typeFactory) {
        RelDataTypeFactory.FieldInfoBuilder fieldInfoBuilder = typeFactory.builder();
        for (ShardingSphereColumn each : table.getAllColumns()) {
            fieldInfoBuilder.add(each.getName(), SQLFederationDataTypeBuilder.getRelDataType(protocolType, each, typeFactory));
        }
        return fieldInfoBuilder.build();
    }

    private static RelDataType getRelDataType(DatabaseType protocolType, ShardingSphereColumn column, RelDataTypeFactory typeFactory) {
        Class<?> sqlTypeClass = SQLFederationDataTypeBuilder.getSqlTypeClass(protocolType, column);
        RelDataType javaType = typeFactory.createJavaType(sqlTypeClass);
        return typeFactory.createTypeWithNullability(javaType, true);
    }

    public static Class<?> getSqlTypeClass(DatabaseType protocolType, ShardingSphereColumn column) {
        return new DatabaseTypeRegistry(protocolType).getDialectDatabaseMetaData().getDataTypeOption().findExtraSQLTypeClass(column.getDataType(), column.isUnsigned()).orElseGet(() -> SqlType.valueOf((int)column.getDataType()).clazz);
    }

    @Generated
    private SQLFederationDataTypeBuilder() {
    }
}

