/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.sql.dialect.impl;

import java.util.List;
import org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.MysqlSqlDialect;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.TimestampWithTimeZoneString;
import org.apache.calcite.util.Util;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;

public final class CustomMySQLSQLDialect
extends MysqlSqlDialect {
    public static final SqlDialect DEFAULT = new CustomMySQLSQLDialect(DEFAULT_CONTEXT);

    public CustomMySQLSQLDialect(SqlDialect.Context context) {
        super(context);
    }

    public void quoteStringLiteral(StringBuilder builder, String charsetName, String value) {
        builder.append(this.literalQuoteString);
        builder.append(value.replace(this.literalEndQuoteString, this.literalEscapedQuote));
        builder.append(this.literalEndQuoteString);
    }

    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (SqlKind.CAST == call.getOperator().getKind()) {
            String typeName;
            SqlNode parameter1 = (SqlNode)call.getOperandList().get(0);
            SqlNode parameter2 = (SqlNode)call.getOperandList().get(1);
            String string = typeName = parameter2 instanceof SqlDataTypeSpec ? (String)Util.last((List)((SqlDataTypeSpec)parameter2).getTypeName().names) : null;
            if (SqlTypeName.DOUBLE.getName().equals(typeName)) {
                this.unparseCastDouble(writer, parameter1, typeName);
                return;
            }
        }
        super.unparseCall(writer, call, leftPrec, rightPrec);
    }

    private void unparseCastDouble(SqlWriter writer, SqlNode parameter1, String typeName) {
        writer.keyword("CAST");
        parameter1.unparse(writer, 0, 0);
        writer.sep("AS");
        writer.keyword(typeName);
        writer.endList(writer.startList((SqlWriter.FrameType)SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")"));
    }

    public void unparseDateTimeLiteral(SqlWriter writer, SqlAbstractDateTimeLiteral literal, int leftPrec, int rightPrec) {
        if (SqlTypeName.TIMESTAMP_TZ == literal.getTypeName()) {
            writer.literal(SqlTypeName.TIMESTAMP.getName() + " '" + this.toFormattedString(literal) + "'");
        } else {
            super.unparseDateTimeLiteral(writer, literal, leftPrec, rightPrec);
        }
    }

    private String toFormattedString(SqlAbstractDateTimeLiteral literal) {
        TimestampWithTimeZoneString timestampWithTimeZone = (TimestampWithTimeZoneString)literal.getValue();
        int precision = literal.getPrec();
        if (precision > 0) {
            timestampWithTimeZone = timestampWithTimeZone.round(precision);
        }
        ShardingSpherePreconditions.checkState((precision >= 0 ? 1 : 0) != 0, () -> new IllegalArgumentException("The precision of timestamp with time zone must be non-negative."));
        return timestampWithTimeZone.getLocalTimestampString().toString(precision);
    }
}

