/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.statement.type;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.DeleteMultiTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DeleteStatement;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.from.TableConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.limit.PaginationValueSQLConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.orderby.OrderByConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.where.WhereConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.with.WithConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.statement.SQLStatementConverter;

public final class DeleteStatementConverter
implements SQLStatementConverter<DeleteStatement, SqlNode> {
    @Override
    public SqlNode convert(DeleteStatement deleteStatement) {
        SqlNode sqlDelete = this.convertDelete(deleteStatement);
        SqlNodeList orderBy = deleteStatement.getOrderBy().flatMap(OrderByConverter::convert).orElse(SqlNodeList.EMPTY);
        Optional limit = deleteStatement.getLimit();
        if (limit.isPresent()) {
            SqlNode offset = ((LimitSegment)limit.get()).getOffset().flatMap(PaginationValueSQLConverter::convert).orElse(null);
            SqlNode rowCount = ((LimitSegment)limit.get()).getRowCount().flatMap(PaginationValueSQLConverter::convert).orElse(null);
            return new SqlOrderBy(SqlParserPos.ZERO, sqlDelete, orderBy, offset, rowCount);
        }
        return orderBy.isEmpty() ? sqlDelete : new SqlOrderBy(SqlParserPos.ZERO, sqlDelete, orderBy, null, null);
    }

    private SqlNode convertDelete(DeleteStatement deleteStatement) {
        return deleteStatement.getTable() instanceof DeleteMultiTableSegment ? this.convertDeleteMultipleTable(deleteStatement) : this.convertDeleteSingleTable(deleteStatement);
    }

    private SqlNode convertDeleteMultipleTable(DeleteStatement deleteStatement) {
        DeleteMultiTableSegment multiTableSegment = (DeleteMultiTableSegment)deleteStatement.getTable();
        SqlNodeList targetTables = this.convertTargetTables(multiTableSegment);
        SqlNodeList targetTableAliases = this.convertTargetTableAliases(multiTableSegment);
        SqlNode condition = deleteStatement.getWhere().flatMap(WhereConverter::convert).orElse(null);
        SqlDelete sqlDelete = new SqlDelete(SqlParserPos.ZERO, targetTables.get(0), condition, null, targetTableAliases.isEmpty() ? null : (SqlIdentifier)targetTableAliases.get(0));
        return (SqlNode)deleteStatement.getWith().flatMap(optional -> WithConverter.convert(optional, (SqlNode)sqlDelete)).orElse(sqlDelete);
    }

    private SqlNodeList convertTargetTables(DeleteMultiTableSegment multiTableSegment) {
        LinkedList sqlNodes = new LinkedList();
        Map<String, SimpleTableSegment> aliasSimpleTables = this.buildAliasSQLNodes(multiTableSegment.getRelationTable());
        for (SimpleTableSegment each : multiTableSegment.getActualDeleteTables()) {
            String tableName = each.getTableName().getIdentifier().getValue();
            SimpleTableSegment tableSegment = !each.getOwner().isPresent() && aliasSimpleTables.containsKey(tableName) ? aliasSimpleTables.get(tableName) : each;
            TableConverter.convert((TableSegment)tableSegment).ifPresent(sqlNodes::add);
        }
        return new SqlNodeList(sqlNodes, SqlParserPos.ZERO);
    }

    private Map<String, SimpleTableSegment> buildAliasSQLNodes(TableSegment tableSegment) {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        if (tableSegment instanceof SimpleTableSegment && tableSegment.getAliasName().isPresent()) {
            result.put((String)tableSegment.getAliasName().get(), new SimpleTableSegment(((SimpleTableSegment)tableSegment).getTableName()));
        }
        if (tableSegment instanceof JoinTableSegment) {
            result.putAll(this.buildAliasSQLNodes(((JoinTableSegment)tableSegment).getLeft()));
            result.putAll(this.buildAliasSQLNodes(((JoinTableSegment)tableSegment).getRight()));
        }
        return result;
    }

    private SqlNodeList convertTargetTableAliases(DeleteMultiTableSegment multiTableSegment) {
        LinkedList sqlNodes = new LinkedList();
        multiTableSegment.getActualDeleteTables().forEach(each -> sqlNodes.add(new SqlIdentifier(each.getTableName().getIdentifier().getValue(), SqlParserPos.ZERO)));
        return new SqlNodeList(sqlNodes, SqlParserPos.ZERO);
    }

    private SqlNode convertDeleteSingleTable(DeleteStatement deleteStatement) {
        SqlNode deleteTable = TableConverter.convert(deleteStatement.getTable()).orElseThrow(IllegalStateException::new);
        SqlNode condition = deleteStatement.getWhere().flatMap(WhereConverter::convert).orElse(null);
        SqlIdentifier alias = deleteStatement.getTable().getAliasName().map(optional -> new SqlIdentifier(optional, SqlParserPos.ZERO)).orElse(null);
        SqlDelete sqlDelete = new SqlDelete(SqlParserPos.ZERO, this.getTargetTableName(deleteTable), condition, null, alias);
        return (SqlNode)deleteStatement.getWith().flatMap(optional -> WithConverter.convert(optional, (SqlNode)sqlDelete)).orElse(sqlDelete);
    }

    private SqlNode getTargetTableName(SqlNode deleteTable) {
        return deleteTable instanceof SqlBasicCall ? (SqlNode)((SqlBasicCall)deleteTable).getOperandList().iterator().next() : deleteTable;
    }
}

