/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.expression.impl;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import java.util.TimeZone;
import lombok.Generated;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.TimestampWithTimeZoneString;
import org.apache.shardingsphere.infra.util.datetime.DateTimeFormatterFactory;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;

public final class LiteralExpressionConverter {
    public static Optional<SqlNode> convert(LiteralExpressionSegment segment, RelDataType dataType) {
        if (null == segment.getLiterals()) {
            return Optional.of(SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO));
        }
        String literalValue = String.valueOf(segment.getLiterals());
        if (segment.getLiterals() instanceof Number) {
            return Optional.of(LiteralExpressionConverter.convertNumber(segment, literalValue));
        }
        if (segment.getLiterals() instanceof String) {
            return Optional.of(SqlLiteral.createCharString((String)literalValue, (SqlParserPos)SqlParserPos.ZERO));
        }
        if (segment.getLiterals() instanceof NlsString) {
            return Optional.of(SqlLiteral.createCharString((String)((NlsString)segment.getLiterals()).getValue(), (SqlParserPos)SqlParserPos.ZERO));
        }
        if (segment.getLiterals() instanceof Boolean) {
            return Optional.of(SqlLiteral.createBoolean((boolean)Boolean.parseBoolean(literalValue), (SqlParserPos)SqlParserPos.ZERO));
        }
        if (segment.getLiterals() instanceof Calendar) {
            return Optional.of(LiteralExpressionConverter.convertCalendar(segment, literalValue, dataType));
        }
        if (segment.getLiterals() instanceof Date) {
            return Optional.of(LiteralExpressionConverter.convertDate(segment, literalValue, dataType));
        }
        if (segment.getLiterals() instanceof TimestampString) {
            return Optional.of(SqlLiteral.createTimestamp((SqlTypeName)SqlTypeName.TIMESTAMP, (TimestampString)((TimestampString)segment.getLiterals()), (int)LiteralExpressionConverter.getTimeScale(literalValue, dataType), (SqlParserPos)SqlParserPos.ZERO));
        }
        if (segment.getLiterals() instanceof LocalDate) {
            return Optional.of(SqlLiteral.createDate((DateString)DateString.fromDaysSinceEpoch((int)((int)((LocalDate)segment.getLiterals()).toEpochDay())), (SqlParserPos)SqlParserPos.ZERO));
        }
        if (segment.getLiterals() instanceof LocalTime) {
            return Optional.of(LiteralExpressionConverter.convertLocalTime(segment, literalValue, dataType));
        }
        if (segment.getLiterals() instanceof LocalDateTime) {
            LocalDateTime dateTime = (LocalDateTime)segment.getLiterals();
            String fraction = literalValue.contains(".") ? literalValue.substring(literalValue.lastIndexOf(46) + 1) : "";
            TimestampString timestampString = TimestampString.fromCalendarFields((Calendar)LiteralExpressionConverter.toCalendar(dateTime.getYear(), dateTime.getMonthValue(), dateTime.getDayOfMonth(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond())).withFraction(fraction);
            return Optional.of(SqlLiteral.createTimestamp((SqlTypeName)SqlTypeName.TIMESTAMP, (TimestampString)timestampString, (int)LiteralExpressionConverter.getTimeScale(literalValue, dataType), (SqlParserPos)SqlParserPos.ZERO));
        }
        if (segment.getLiterals() instanceof ZonedDateTime) {
            return Optional.of(SqlLiteral.createTimestamp((TimestampWithTimeZoneString)new TimestampWithTimeZoneString(literalValue), (int)LiteralExpressionConverter.getTimeScale(literalValue, dataType), (SqlParserPos)SqlParserPos.ZERO));
        }
        if (segment.getLiterals() instanceof byte[]) {
            return Optional.of(SqlLiteral.createBinaryString((byte[])((byte[])segment.getLiterals()), (SqlParserPos)SqlParserPos.ZERO));
        }
        if (segment.getLiterals() instanceof Enum) {
            return Optional.of(SqlLiteral.createCharString((String)((Enum)segment.getLiterals()).name(), (SqlParserPos)SqlParserPos.ZERO));
        }
        return Optional.empty();
    }

    private static SqlNode convertNumber(LiteralExpressionSegment segment, String literalValue) {
        if (segment.getLiterals() instanceof Float || segment.getLiterals() instanceof Double) {
            return SqlLiteral.createApproxNumeric((String)literalValue, (SqlParserPos)SqlParserPos.ZERO);
        }
        return SqlLiteral.createExactNumeric((String)literalValue, (SqlParserPos)SqlParserPos.ZERO);
    }

    private static SqlNode convertCalendar(LiteralExpressionSegment segment, String literalValue, RelDataType dataType) {
        Calendar calendar = (Calendar)segment.getLiterals();
        if (LiteralExpressionConverter.hasTimePart(calendar)) {
            return SqlLiteral.createTimestamp((SqlTypeName)SqlTypeName.TIMESTAMP, (TimestampString)TimestampString.fromCalendarFields((Calendar)calendar), (int)LiteralExpressionConverter.getTimeScale(literalValue, dataType), (SqlParserPos)SqlParserPos.ZERO);
        }
        return SqlLiteral.createDate((DateString)DateString.fromCalendarFields((Calendar)calendar), (SqlParserPos)SqlParserPos.ZERO);
    }

    private static boolean hasTimePart(Calendar calendar) {
        return 0 != calendar.get(11) || 0 != calendar.get(12) || 0 != calendar.get(13) || 0 != calendar.get(14);
    }

    private static SqlNode convertDate(LiteralExpressionSegment segment, String literalValue, RelDataType dataType) {
        if (segment.getLiterals() instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)segment.getLiterals();
            LocalDateTime dateTime = timestamp.toLocalDateTime();
            String fraction = literalValue.contains(".") ? literalValue.substring(literalValue.lastIndexOf(46) + 1) : "";
            TimestampWithTimeZoneString timestampWithTimeZone = TimestampWithTimeZoneString.fromCalendarFields((Calendar)LiteralExpressionConverter.toCalendar(dateTime.getYear(), dateTime.getMonthValue(), dateTime.getDayOfMonth(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond())).withFraction(fraction).withTimeZone(TimeZone.getDefault());
            return SqlLiteral.createTimestamp((TimestampWithTimeZoneString)timestampWithTimeZone, (int)LiteralExpressionConverter.getTimeScale(literalValue, dataType), (SqlParserPos)SqlParserPos.ZERO);
        }
        if (segment.getLiterals() instanceof Time) {
            return SqlLiteral.createTime((TimeString)new TimeString(literalValue), (int)LiteralExpressionConverter.getTimeScale(literalValue, dataType), (SqlParserPos)SqlParserPos.ZERO);
        }
        return SqlLiteral.createDate((DateString)new DateString(literalValue), (SqlParserPos)SqlParserPos.ZERO);
    }

    private static SqlNode convertLocalTime(LiteralExpressionSegment segment, String literalValue, RelDataType dataType) {
        LocalTime localTime = (LocalTime)segment.getLiterals();
        int nanos = localTime.getNano();
        String formattedValue = 0 == nanos ? DateTimeFormatterFactory.getTimeFormatter().format(localTime) : DateTimeFormatterFactory.getFullTimeFormatter().format(localTime);
        return SqlLiteral.createTime((TimeString)new TimeString(formattedValue), (int)LiteralExpressionConverter.getTimeScale(literalValue, dataType), (SqlParserPos)SqlParserPos.ZERO);
    }

    private static int getTimeScale(String literalValue, RelDataType dataType) {
        if (null != dataType && dataType.getScale() > 0) {
            return dataType.getScale();
        }
        return literalValue.contains(".") ? literalValue.substring(literalValue.lastIndexOf(".")).length() : 0;
    }

    private static Calendar toCalendar(int year, int month, int day, int hour, int minute, int second) {
        Calendar result = Calendar.getInstance();
        result.clear();
        result.set(year, month - 1, day, hour, minute, second);
        return result;
    }

    @Generated
    private LiteralExpressionConverter() {
    }
}

