/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.expression.impl;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.interval.IntervalUnitExpression;

public final class IntervalUnitExpressionConverter {
    private static final Collection<String> TIME_UNIT_NAMES = new CaseInsensitiveSet(7, 1.0f);

    public static Optional<SqlNode> convert(IntervalUnitExpression segment) {
        String intervalUnit = segment.getIntervalUnit().name();
        if (TIME_UNIT_NAMES.contains(intervalUnit)) {
            return Optional.of(new SqlIntervalQualifier(TimeUnit.valueOf((String)intervalUnit), null, SqlParserPos.ZERO));
        }
        return Optional.of(SqlLiteral.createCharString((String)intervalUnit, (SqlParserPos)SqlParserPos.ZERO));
    }

    @Generated
    private IntervalUnitExpressionConverter() {
    }

    static {
        TIME_UNIT_NAMES.add("YEAR");
        TIME_UNIT_NAMES.add("MONTH");
        TIME_UNIT_NAMES.add("WEEK");
        TIME_UNIT_NAMES.add("DAY");
        TIME_UNIT_NAMES.add("HOUR");
        TIME_UNIT_NAMES.add("MINUTE");
        TIME_UNIT_NAMES.add("SECOND");
    }
}

