/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.expression.impl;

import java.util.ArrayList;
import lombok.Generated;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.IntervalExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.IntervalUnit;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.operator.common.SQLExtensionOperatorTable;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.expression.ExpressionConverter;

public final class IntervalExpressionConverter {
    public static SqlBasicCall convert(IntervalExpression segment) {
        TimeUnit timeUnit = IntervalExpressionConverter.getTimeUnit(segment.getIntervalUnit());
        ArrayList<SqlIntervalQualifier> sqlNodes = new ArrayList<SqlIntervalQualifier>();
        ExpressionConverter.convert(segment.getValue()).ifPresent(sqlNodes::add);
        sqlNodes.add(new SqlIntervalQualifier(timeUnit, timeUnit, SqlParserPos.ZERO));
        return new SqlBasicCall((SqlOperator)SQLExtensionOperatorTable.INTERVAL_OPERATOR, sqlNodes, SqlParserPos.ZERO);
    }

    private static TimeUnit getTimeUnit(IntervalUnit unit) {
        switch (unit) {
            case MICROSECOND: {
                return TimeUnit.MICROSECOND;
            }
            case SECOND: {
                return TimeUnit.SECOND;
            }
            case MINUTE: {
                return TimeUnit.MINUTE;
            }
            case HOUR: {
                return TimeUnit.HOUR;
            }
            case DAY: {
                return TimeUnit.DAY;
            }
            case WEEK: {
                return TimeUnit.WEEK;
            }
            case MONTH: {
                return TimeUnit.MONTH;
            }
            case QUARTER: {
                return TimeUnit.QUARTER;
            }
            case YEAR: {
                return TimeUnit.YEAR;
            }
        }
        throw new UnsupportedOperationException("Unsupported interval unit");
    }

    @Generated
    private IntervalExpressionConverter() {
    }
}

