/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.rel.converter;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sqlfederation.compiler.context.CompilerContext;
import org.apache.shardingsphere.sqlfederation.compiler.metadata.catalog.SQLFederationCatalogReader;
import org.apache.shardingsphere.sqlfederation.compiler.metadata.view.ShardingSphereViewExpander;
import org.apache.shardingsphere.sqlfederation.compiler.planner.builder.SQLFederationPlannerBuilder;
import org.apache.shardingsphere.sqlfederation.compiler.sql.type.SQLFederationDataTypeFactory;

public final class SQLFederationRelConverter {
    private final SqlToRelConverter sqlToRelConverter;

    public SQLFederationRelConverter(CompilerContext compilerContext, List<String> schemaPath, DatabaseType databaseType, Convention convention) {
        RelDataTypeFactory typeFactory = SQLFederationDataTypeFactory.getInstance();
        CalciteConnectionConfig connectionConfig = compilerContext.getConnectionConfig();
        SQLFederationCatalogReader catalogReader = new SQLFederationCatalogReader(compilerContext.getCalciteSchema(), schemaPath, typeFactory, connectionConfig);
        SqlValidator validator = this.createSqlValidator(catalogReader, typeFactory, connectionConfig, compilerContext.getOperatorTables());
        RelOptCluster relOptCluster = this.createRelOptCluster(typeFactory, convention);
        this.sqlToRelConverter = this.createSqlToRelConverter(catalogReader, validator, relOptCluster, compilerContext.getSqlParserRule(), databaseType, true);
    }

    private SqlValidator createSqlValidator(CalciteCatalogReader catalogReader, RelDataTypeFactory typeFactory, CalciteConnectionConfig connectionConfig, Collection<SqlOperatorTable> operatorTables) {
        SqlValidator.Config validatorConfig = SqlValidator.Config.DEFAULT.withLenientOperatorLookup(connectionConfig.lenientOperatorLookup()).withConformance(connectionConfig.conformance()).withDefaultNullCollation(connectionConfig.defaultNullCollation()).withIdentifierExpansion(true);
        SqlOperatorTable sqlOperatorTable = SQLFederationRelConverter.getSQLOperatorTable(operatorTables, catalogReader);
        return SqlValidatorUtil.newValidator((SqlOperatorTable)sqlOperatorTable, (SqlValidatorCatalogReader)catalogReader, (RelDataTypeFactory)typeFactory, (SqlValidator.Config)validatorConfig);
    }

    private static SqlOperatorTable getSQLOperatorTable(Collection<SqlOperatorTable> operatorTables, CalciteCatalogReader catalogReader) {
        LinkedList<SqlOperatorTable> allOperatorTables = new LinkedList<SqlOperatorTable>(operatorTables);
        allOperatorTables.add((SqlOperatorTable)catalogReader);
        return SqlOperatorTables.chain(allOperatorTables);
    }

    private SqlToRelConverter createSqlToRelConverter(CalciteCatalogReader catalogReader, SqlValidator validator, RelOptCluster cluster, SQLParserRule sqlParserRule, DatabaseType databaseType, boolean needsViewExpand) {
        RelOptTable.ViewExpander expander = needsViewExpand ? new ShardingSphereViewExpander(sqlParserRule, databaseType, this.createSqlToRelConverter(catalogReader, validator, cluster, sqlParserRule, databaseType, false)) : (rowType, queryString, schemaPath, viewPath) -> null;
        SqlToRelConverter.Config converterConfig = SqlToRelConverter.config().withTrimUnusedFields(true).withRemoveSortInSubQuery(false);
        return new SqlToRelConverter(expander, validator, (Prepare.CatalogReader)catalogReader, cluster, (SqlRexConvertletTable)StandardConvertletTable.INSTANCE, converterConfig);
    }

    private RelOptCluster createRelOptCluster(RelDataTypeFactory typeFactory, Convention convention) {
        RelOptPlanner volcanoPlanner = SQLFederationPlannerBuilder.buildVolcanoPlanner(convention);
        return RelOptCluster.create((RelOptPlanner)volcanoPlanner, (RexBuilder)new RexBuilder(typeFactory));
    }

    public SchemaPlus getSchemaPlus() {
        return this.sqlToRelConverter.validator.getCatalogReader().getRootSchema().plus();
    }

    public RelRoot convertQuery(SqlNode sqlNode, boolean needsValidation, boolean top) {
        return this.sqlToRelConverter.convertQuery(sqlNode, needsValidation, top);
    }

    public RelDataType getValidatedNodeType(SqlNode sqlNode) {
        return Objects.requireNonNull(this.sqlToRelConverter.validator).getValidatedNodeType(sqlNode);
    }

    public RelOptCluster getCluster() {
        return this.sqlToRelConverter.getCluster();
    }
}

