/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.planner.builder;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.rules.AggregateExpandDistinctAggregatesRule;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.shardingsphere.sqlfederation.compiler.planner.rule.converter.EnumerableModifyConverterRule;
import org.apache.shardingsphere.sqlfederation.compiler.planner.rule.converter.EnumerableScanConverterRule;
import org.apache.shardingsphere.sqlfederation.compiler.planner.rule.transformation.PushFilterIntoScanRule;
import org.apache.shardingsphere.sqlfederation.compiler.planner.rule.transformation.PushProjectIntoScanRule;

public final class SQLFederationPlannerBuilder {
    private static final int GLOBAL_MATCH_LIMIT = 1024;
    private static final int GROUP_MATCH_LIMIT = 500;

    public static RelOptPlanner buildVolcanoPlanner(Convention convention) {
        VolcanoPlanner result = new VolcanoPlanner();
        SQLFederationPlannerBuilder.setUpRules((RelOptPlanner)result, convention);
        return result;
    }

    private static void setUpRules(RelOptPlanner planner, Convention convention) {
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef((RelTraitDef)RelCollationTraitDef.INSTANCE);
        if (EnumerableConvention.INSTANCE == convention) {
            SQLFederationPlannerBuilder.setUpEnumerableConventionRules(planner);
        }
    }

    private static void setUpEnumerableConventionRules(RelOptPlanner planner) {
        planner.addRule(EnumerableRules.ENUMERABLE_JOIN_RULE);
        planner.addRule(EnumerableRules.ENUMERABLE_MERGE_JOIN_RULE);
        planner.addRule(EnumerableRules.ENUMERABLE_CORRELATE_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_PROJECT_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_FILTER_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_CALC_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_AGGREGATE_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_SORT_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_LIMIT_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_COLLECT_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_UNCOLLECT_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_UNION_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_REPEAT_UNION_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_TABLE_SPOOL_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_INTERSECT_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_MINUS_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_VALUES_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_WINDOW_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_TABLE_SCAN_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_TABLE_FUNCTION_SCAN_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_MATCH_RULE);
        planner.addRule(EnumerableScanConverterRule.DEFAULT_CONFIG.toRule());
        planner.addRule(EnumerableModifyConverterRule.DEFAULT_CONFIG.toRule());
    }

    public static RelOptPlanner buildHepPlanner() {
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addGroupBegin().addRuleCollection(SQLFederationPlannerBuilder.getSubQueryRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP).addMatchLimit(500);
        builder.addGroupBegin().addRuleCollection(SQLFederationPlannerBuilder.getJoinRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP).addMatchLimit(500);
        builder.addGroupBegin().addRuleCollection(SQLFederationPlannerBuilder.getFilterRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP).addMatchLimit(500);
        builder.addGroupBegin().addRuleCollection(SQLFederationPlannerBuilder.getProjectRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP).addMatchLimit(500);
        builder.addGroupBegin().addRuleCollection(SQLFederationPlannerBuilder.getAggregationRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP).addMatchLimit(500);
        builder.addGroupBegin().addRuleCollection(SQLFederationPlannerBuilder.getSortRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP).addMatchLimit(500);
        builder.addGroupBegin().addRuleCollection(SQLFederationPlannerBuilder.getPushIntoScanRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP).addMatchLimit(500);
        builder.addGroupBegin().addRuleCollection(SQLFederationPlannerBuilder.getCalcRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP).addMatchLimit(500);
        builder.addMatchLimit(1024);
        return new HepPlanner(builder.build());
    }

    private static Collection<RelOptRule> getSubQueryRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)CoreRules.FILTER_SUB_QUERY_TO_CORRELATE);
        result.add((RelOptRule)CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE);
        result.add((RelOptRule)CoreRules.JOIN_SUB_QUERY_TO_CORRELATE);
        return result;
    }

    private static Collection<RelOptRule> getSortRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)CoreRules.SORT_JOIN_TRANSPOSE);
        return result;
    }

    private static Collection<RelOptRule> getPushIntoScanRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)PushFilterIntoScanRule.Config.DEFAULT.toRule());
        result.add((RelOptRule)PushProjectIntoScanRule.Config.DEFAULT.toRule());
        return result;
    }

    private static Collection<RelOptRule> getCalcRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)AggregateExpandDistinctAggregatesRule.Config.DEFAULT.toRule());
        result.add((RelOptRule)CoreRules.PROJECT_TO_CALC);
        result.add((RelOptRule)CoreRules.FILTER_TO_CALC);
        result.add((RelOptRule)CoreRules.PROJECT_CALC_MERGE);
        result.add((RelOptRule)CoreRules.FILTER_CALC_MERGE);
        result.add((RelOptRule)EnumerableRules.ENUMERABLE_FILTER_TO_CALC_RULE);
        result.add((RelOptRule)EnumerableRules.ENUMERABLE_PROJECT_TO_CALC_RULE);
        result.add((RelOptRule)CoreRules.CALC_MERGE);
        return result;
    }

    private static Collection<RelOptRule> getProjectRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)CoreRules.PROJECT_MERGE);
        result.add((RelOptRule)CoreRules.PROJECT_CORRELATE_TRANSPOSE);
        result.add((RelOptRule)CoreRules.PROJECT_SET_OP_TRANSPOSE);
        result.add((RelOptRule)CoreRules.PROJECT_REDUCE_EXPRESSIONS);
        result.add((RelOptRule)ProjectRemoveRule.Config.DEFAULT.toRule());
        return result;
    }

    private static Collection<RelOptRule> getJoinRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)CoreRules.PROJECT_JOIN_TRANSPOSE);
        result.add((RelOptRule)CoreRules.JOIN_CONDITION_PUSH);
        result.add((RelOptRule)CoreRules.JOIN_PUSH_EXPRESSIONS);
        result.add((RelOptRule)CoreRules.JOIN_PUSH_TRANSITIVE_PREDICATES);
        return result;
    }

    private static Collection<RelOptRule> getFilterRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)CoreRules.FILTER_INTO_JOIN);
        result.add((RelOptRule)CoreRules.FILTER_AGGREGATE_TRANSPOSE);
        result.add((RelOptRule)CoreRules.FILTER_SET_OP_TRANSPOSE);
        result.add((RelOptRule)CoreRules.FILTER_REDUCE_EXPRESSIONS);
        result.add((RelOptRule)CoreRules.FILTER_MERGE);
        result.add((RelOptRule)CoreRules.FILTER_PROJECT_TRANSPOSE);
        result.add((RelOptRule)CoreRules.JOIN_PUSH_TRANSITIVE_PREDICATES);
        return result;
    }

    private static Collection<RelOptRule> getAggregationRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)CoreRules.AGGREGATE_MERGE);
        result.add((RelOptRule)CoreRules.AGGREGATE_REDUCE_FUNCTIONS);
        return result;
    }

    @Generated
    private SQLFederationPlannerBuilder() {
    }
}

