/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.metadata.schema;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ModifiableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.sqlfederation.compiler.implementor.ScanImplementor;
import org.apache.shardingsphere.sqlfederation.compiler.implementor.ScanImplementorContext;
import org.apache.shardingsphere.sqlfederation.compiler.implementor.enumerator.EmptyDataRowEnumerator;
import org.apache.shardingsphere.sqlfederation.compiler.sql.type.SQLFederationDataTypeBuilder;

public final class SQLFederationTable
extends AbstractTable
implements ModifiableTable,
TranslatableTable {
    private static final TransmittableThreadLocal<ScanImplementor> SCAN_IMPLEMENTOR_HOLDER = new TransmittableThreadLocal();
    private final ShardingSphereTable table;
    private final DatabaseType protocolType;

    public Enumerable<Object> implement(DataContext root, String sql, int[] paramIndexes) {
        return null == SCAN_IMPLEMENTOR_HOLDER.get() ? this.createEmptyEnumerable() : ((ScanImplementor)SCAN_IMPLEMENTOR_HOLDER.get()).implement(this.table, new ScanImplementorContext(root, sql, paramIndexes));
    }

    private AbstractEnumerable<Object> createEmptyEnumerable() {
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                return new EmptyDataRowEnumerator();
            }
        };
    }

    public void setScanImplementor(ScanImplementor scanImplementor) {
        SCAN_IMPLEMENTOR_HOLDER.set((Object)scanImplementor);
    }

    public void clearScanImplementor() {
        SCAN_IMPLEMENTOR_HOLDER.remove();
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return SQLFederationDataTypeBuilder.build(this.table, this.protocolType, typeFactory);
    }

    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
        return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
    }

    public Type getElementType() {
        return Object[].class;
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        throw new UnsupportedSQLOperationException("asQueryable");
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return LogicalTableScan.create((RelOptCluster)context.getCluster(), (RelOptTable)relOptTable, Collections.emptyList());
    }

    public Collection<Object[]> getModifiableCollection() {
        throw new UnsupportedOperationException();
    }

    public TableModify toModificationRel(RelOptCluster relOptCluster, RelOptTable table, Prepare.CatalogReader schema, RelNode relNode, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
        return LogicalTableModify.create((RelOptTable)table, (Prepare.CatalogReader)schema, (RelNode)relNode, (TableModify.Operation)operation, updateColumnList, sourceExpressionList, (boolean)flattened);
    }

    public String toString() {
        return "SQLFederationTable";
    }

    @Generated
    public SQLFederationTable(ShardingSphereTable table, DatabaseType protocolType) {
        this.table = table;
        this.protocolType = protocolType;
    }
}

