/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.context.schema;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.lookup.LikePattern;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sqlfederation.compiler.metadata.schema.SQLFederationDatabase;
import org.apache.shardingsphere.sqlfederation.compiler.metadata.schema.SQLFederationSchema;
import org.apache.shardingsphere.sqlfederation.compiler.sql.function.DialectSQLFederationFunctionRegister;

public final class CalciteSchemaBuilder {
    public static CalciteSchema build(Collection<ShardingSphereDatabase> databases) {
        CalciteSchema result = CalciteSchema.createRootSchema((boolean)true);
        for (ShardingSphereDatabase each : databases) {
            if (each.getAllSchemas().isEmpty()) continue;
            Optional defaultSchema = new DatabaseTypeRegistry(each.getProtocolType()).getDialectDatabaseMetaData().getSchemaOption().getDefaultSchema();
            AbstractSchema schema = defaultSchema.isPresent() ? CalciteSchemaBuilder.buildDatabase(each) : CalciteSchemaBuilder.buildSchema((ShardingSphereSchema)each.getAllSchemas().iterator().next(), each.getProtocolType());
            result.add(each.getName(), (Schema)schema);
        }
        CalciteSchemaBuilder.registerFunction(databases, result);
        return result;
    }

    private static AbstractSchema buildDatabase(ShardingSphereDatabase database) {
        return new SQLFederationDatabase(database, database.getProtocolType());
    }

    private static AbstractSchema buildSchema(ShardingSphereSchema schema, DatabaseType protocolType) {
        return new SQLFederationSchema(schema.getName(), schema, protocolType);
    }

    private static void registerFunction(Collection<ShardingSphereDatabase> databases, CalciteSchema calciteSchema) {
        DatabaseType databaseType = databases.isEmpty() ? DatabaseTypeEngine.getDefaultStorageType() : databases.iterator().next().getProtocolType();
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        if (dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().isPresent()) {
            CalciteSchemaBuilder.registerNestedSchemaFunction(calciteSchema, databaseType);
        } else {
            CalciteSchemaBuilder.registerFunction(calciteSchema, databaseType);
        }
    }

    private static void registerFunction(CalciteSchema calciteSchema, DatabaseType databaseType) {
        for (CalciteSchema each : calciteSchema.getSubSchemaMap().values()) {
            DatabaseTypedSPILoader.findService(DialectSQLFederationFunctionRegister.class, (DatabaseType)databaseType).ifPresent(optional -> optional.registerFunction(each.plus(), each.getName()));
        }
    }

    private static void registerFunction(Collection<CalciteSchema> subSchemas, DatabaseType databaseType) {
        for (CalciteSchema each : subSchemas) {
            DatabaseTypedSPILoader.findService(DialectSQLFederationFunctionRegister.class, (DatabaseType)databaseType).ifPresent(optional -> optional.registerFunction(each.plus(), each.getName()));
        }
    }

    private static void registerNestedSchemaFunction(CalciteSchema calciteSchema, DatabaseType databaseType) {
        for (CalciteSchema each : calciteSchema.getSubSchemaMap().values()) {
            CalciteSchemaBuilder.registerFunction(each.subSchemas().getNames(LikePattern.any()).stream().map(schemaName -> (CalciteSchema)each.subSchemas().get(schemaName)).collect(Collectors.toList()), databaseType);
        }
    }

    @Generated
    private CalciteSchemaBuilder() {
    }
}

