/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.context.connection.config;

import java.util.Properties;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.Lex;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sqlfederation.compiler.context.connection.config.DialectSQLFederationConnectionConfigBuilder;

public final class SQLFederationConnectionConfigBuilderFactory {
    private final DialectSQLFederationConnectionConfigBuilder dialectBuilder;

    public SQLFederationConnectionConfigBuilderFactory(DatabaseType databaseType) {
        this.dialectBuilder = DatabaseTypedSPILoader.findService(DialectSQLFederationConnectionConfigBuilder.class, (DatabaseType)databaseType).orElse(null);
    }

    public CalciteConnectionConfig build() {
        return null == this.dialectBuilder ? this.buildStandardConnectionConfig() : this.dialectBuilder.build();
    }

    private CalciteConnectionConfig buildStandardConnectionConfig() {
        Properties result = new Properties();
        result.setProperty(CalciteConnectionProperty.LEX.camelName(), Lex.JAVA.name());
        result.setProperty(CalciteConnectionProperty.CONFORMANCE.camelName(), SqlConformanceEnum.LENIENT.name());
        result.setProperty(CalciteConnectionProperty.FUN.camelName(), SqlLibrary.STANDARD.fun);
        result.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(Lex.JAVA.caseSensitive));
        return new CalciteConnectionConfigImpl(result);
    }
}

