/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.context;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLibraryOperatorTableFactory;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.parser.rule.builder.DefaultSQLParserRuleConfigurationBuilder;
import org.apache.shardingsphere.parser.rule.builder.SQLParserRuleBuilder;
import org.apache.shardingsphere.sqlfederation.compiler.context.CompilerContext;
import org.apache.shardingsphere.sqlfederation.compiler.context.connection.config.SQLFederationConnectionConfigBuilderFactory;
import org.apache.shardingsphere.sqlfederation.compiler.context.schema.CalciteSchemaBuilder;
import org.apache.shardingsphere.sqlfederation.compiler.sql.function.mysql.MySQLOperatorTable;

public final class CompilerContextFactory {
    private static final Map<String, SqlLibrary> DATABASE_TYPE_SQL_LIBRARIES = new CaseInsensitiveMap();

    public static CompilerContext create(Collection<ShardingSphereDatabase> databases) {
        SQLParserRule sqlParserRule = new SQLParserRuleBuilder().build(new DefaultSQLParserRuleConfigurationBuilder().build(), databases, new ConfigurationProperties(new Properties()));
        DatabaseType databaseType = databases.isEmpty() ? DatabaseTypeEngine.getDefaultStorageType() : databases.iterator().next().getProtocolType();
        CalciteConnectionConfig connectionConfig = new SQLFederationConnectionConfigBuilderFactory(databaseType).build();
        CalciteSchema calciteSchema = CalciteSchemaBuilder.build(databases);
        return new CompilerContext(sqlParserRule, calciteSchema, connectionConfig, CompilerContextFactory.getOperatorTables(databaseType));
    }

    private static Collection<SqlOperatorTable> getOperatorTables(DatabaseType databaseType) {
        SqlOperatorTable operatorTable = SqlLibraryOperatorTableFactory.INSTANCE.getOperatorTable(Arrays.asList(SqlLibrary.STANDARD, DATABASE_TYPE_SQL_LIBRARIES.getOrDefault(databaseType.getType(), SqlLibrary.MYSQL)));
        return Arrays.asList(new SqlOperatorTable[]{new MySQLOperatorTable(), operatorTable});
    }

    @Generated
    private CompilerContextFactory() {
    }

    static {
        DATABASE_TYPE_SQL_LIBRARIES.put("MySQL", SqlLibrary.MYSQL);
        DATABASE_TYPE_SQL_LIBRARIES.put("PostgreSQL", SqlLibrary.POSTGRESQL);
        DATABASE_TYPE_SQL_LIBRARIES.put("openGauss", SqlLibrary.POSTGRESQL);
        DATABASE_TYPE_SQL_LIBRARIES.put("Oracle", SqlLibrary.ORACLE);
    }
}

