/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.compiler;

import lombok.Generated;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQueryBase;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlNode;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sqlfederation.compiler.SQLFederationExecutionPlan;
import org.apache.shardingsphere.sqlfederation.compiler.planner.builder.SQLFederationPlannerBuilder;
import org.apache.shardingsphere.sqlfederation.compiler.rel.converter.SQLFederationRelConverter;
import org.apache.shardingsphere.sqlfederation.compiler.rel.rewriter.LogicalScanRelRewriter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.SQLNodeConverterEngine;

public final class SQLStatementCompiler {
    private final SQLFederationRelConverter converter;
    private final Convention convention;

    public SQLFederationExecutionPlan compile(SQLStatement sqlStatement, String databaseType) {
        RelMetadataQueryBase.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.DEFAULT);
        SqlNode sqlNode = SQLNodeConverterEngine.convert(sqlStatement);
        RelNode logicalPlan = this.converter.convertQuery((SqlNode)sqlNode, (boolean)true, (boolean)true).rel;
        RelDataType resultColumnType = this.converter.getValidatedNodeType(sqlNode);
        RelNode rewrittenPlan = this.rewrite(logicalPlan, databaseType);
        RelNode physicalPlan = this.optimize(rewrittenPlan, this.converter, databaseType);
        RelMetadataQueryBase.THREAD_PROVIDERS.remove();
        return new SQLFederationExecutionPlan(physicalPlan, resultColumnType);
    }

    private RelNode rewrite(RelNode logicalPlan, String databaseType) {
        RelNode rewrittenPlan = this.rewriteTableScan(logicalPlan, databaseType);
        RelOptPlanner hepPlanner = SQLFederationPlannerBuilder.buildHepPlanner();
        hepPlanner.setRoot(rewrittenPlan);
        return hepPlanner.findBestExp();
    }

    private RelNode optimize(RelNode logicalPlan, SQLFederationRelConverter converter, String databaseType) {
        RelNode rewrittenPlan = this.rewriteTableScan(logicalPlan, databaseType);
        RelOptPlanner planner = converter.getCluster().getPlanner();
        planner.setRoot(rewrittenPlan.getTraitSet().contains((RelTrait)this.convention) ? rewrittenPlan : planner.changeTraits(rewrittenPlan, converter.getCluster().traitSet().replace((RelTrait)this.convention)));
        return planner.findBestExp();
    }

    private RelNode rewriteTableScan(RelNode logicalPlan, String databaseType) {
        return LogicalScanRelRewriter.rewrite(logicalPlan, databaseType);
    }

    @Generated
    public SQLStatementCompiler(SQLFederationRelConverter converter, Convention convention) {
        this.converter = converter;
        this.convention = convention;
    }
}

