/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.narayana.manager;

import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import com.google.common.base.Preconditions;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataSourceXAResourceRecoveryHelper
implements XAResourceRecoveryHelper,
XAResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceXAResourceRecoveryHelper.class);
    private static final XAResource[] NO_XA_RESOURCES = new XAResource[0];
    private final XADataSource xaDataSource;
    private final String user;
    private final String password;
    private XAConnection xaConnection;
    private XAResource delegate;

    public DataSourceXAResourceRecoveryHelper(XADataSource xaDataSource) {
        this(xaDataSource, null, null);
    }

    public boolean initialise(String props) {
        return true;
    }

    public XAResource[] getXAResources() {
        if (this.connect()) {
            return new XAResource[]{this};
        }
        return NO_XA_RESOURCES;
    }

    private boolean connect() {
        if (null == this.delegate) {
            try {
                this.xaConnection = this.getXaConnection();
                this.delegate = this.xaConnection.getXAResource();
            }
            catch (SQLException ex) {
                log.warn("Failed to create connection", (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    private XAConnection getXaConnection() throws SQLException {
        return null == this.user && null == this.password ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(this.user, this.password);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        try {
            Xid[] xidArray = this.getDelegate().recover(flag);
            return xidArray;
        }
        finally {
            if (flag == 0x800000) {
                this.disconnect();
            }
        }
    }

    private void disconnect() {
        try {
            this.xaConnection.close();
        }
        catch (SQLException ex) {
            log.warn("Failed to close connection", (Throwable)ex);
        }
        finally {
            this.xaConnection = null;
            this.delegate = null;
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.getDelegate().start(xid, flags);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.getDelegate().end(xid, flags);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.getDelegate().prepare(xid);
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.getDelegate().commit(xid, onePhase);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.getDelegate().rollback(xid);
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return this.getDelegate().isSameRM(xaResource);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.getDelegate().forget(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.getDelegate().getTransactionTimeout();
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.getDelegate().setTransactionTimeout(seconds);
    }

    private XAResource getDelegate() {
        Preconditions.checkNotNull((Object)this.delegate, (Object)"Connection has not been opened");
        return this.delegate;
    }

    @Generated
    public DataSourceXAResourceRecoveryHelper(XADataSource xaDataSource, String user, String password) {
        this.xaDataSource = xaDataSource;
        this.user = user;
        this.password = password;
    }
}

