/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.dml;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.assign.AssignmentSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.column.InsertColumnsSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.expression.type.SubquerySegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.with.WithSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementCopyUtils;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;

public final class InsertStatementBinder
implements SQLStatementBinder<InsertStatement> {
    @Override
    public InsertStatement bind(InsertStatement sqlStatement, SQLStatementBinderContext binderContext) {
        LinkedHashMultimap tableBinderContexts = LinkedHashMultimap.create();
        WithSegment boundWith = sqlStatement.getWith().map(optional -> WithSegmentBinder.bind(optional, binderContext, binderContext.getExternalTableBinderContexts())).orElse(null);
        SimpleTableSegment boundTable = sqlStatement.getTable().map(arg_0 -> InsertStatementBinder.lambda$bind$1(binderContext, (Multimap)tableBinderContexts, arg_0)).orElse(null);
        InsertColumnsSegment boundInsertColumns = sqlStatement.getInsertColumns().isPresent() && !((InsertColumnsSegment)sqlStatement.getInsertColumns().get()).getColumns().isEmpty() ? InsertColumnsSegmentBinder.bind((InsertColumnsSegment)sqlStatement.getInsertColumns().get(), binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts) : (InsertColumnsSegment)sqlStatement.getInsertColumns().orElse(null);
        SetAssignmentSegment boundSetAssignment = sqlStatement.getSetAssignment().map(arg_0 -> InsertStatementBinder.lambda$bind$2(binderContext, (Multimap)tableBinderContexts, arg_0)).orElse(null);
        SubquerySegment boundInsertSelect = sqlStatement.getInsertSelect().map(arg_0 -> InsertStatementBinder.lambda$bind$3(binderContext, (Multimap)tableBinderContexts, arg_0)).orElse(null);
        InsertStatement result = this.copy(sqlStatement, boundWith, boundTable, boundInsertColumns, boundSetAssignment, boundInsertSelect);
        if (!sqlStatement.getInsertColumns().isPresent() || ((InsertColumnsSegment)sqlStatement.getInsertColumns().get()).getColumns().isEmpty()) {
            tableBinderContexts.values().forEach(each -> result.getDerivedInsertColumns().addAll(this.getVisibleColumns(each.getProjectionSegments())));
        }
        return result;
    }

    private InsertStatement copy(InsertStatement sqlStatement, WithSegment boundWith, SimpleTableSegment boundTable, InsertColumnsSegment boundInsertColumns, SetAssignmentSegment boundSetAssignment, SubquerySegment boundInsertSelect) {
        InsertStatement result = new InsertStatement(sqlStatement.getDatabaseType());
        result.setWith(boundWith);
        result.setTable(boundTable);
        result.setInsertColumns(boundInsertColumns);
        result.setSetAssignment(boundSetAssignment);
        result.setInsertSelect(boundInsertSelect);
        result.getValues().addAll(sqlStatement.getValues());
        result.setIgnore(sqlStatement.isIgnore());
        result.setReplace(sqlStatement.isReplace());
        sqlStatement.getOnDuplicateKeyColumns().ifPresent(arg_0 -> ((InsertStatement)result).setOnDuplicateKeyColumns(arg_0));
        sqlStatement.getOutput().ifPresent(arg_0 -> ((InsertStatement)result).setOutput(arg_0));
        sqlStatement.getMultiTableInsertType().ifPresent(arg_0 -> ((InsertStatement)result).setMultiTableInsertType(arg_0));
        sqlStatement.getMultiTableInsertInto().ifPresent(arg_0 -> ((InsertStatement)result).setMultiTableInsertInto(arg_0));
        sqlStatement.getMultiTableConditionalInto().ifPresent(arg_0 -> ((InsertStatement)result).setMultiTableConditionalInto(arg_0));
        sqlStatement.getReturning().ifPresent(arg_0 -> ((InsertStatement)result).setReturning(arg_0));
        SQLStatementCopyUtils.copyAttributes((SQLStatement)sqlStatement, (SQLStatement)result);
        return result;
    }

    private Collection<ColumnSegment> getVisibleColumns(Collection<ProjectionSegment> projectionSegments) {
        return projectionSegments.stream().filter(each -> each instanceof ColumnProjectionSegment && each.isVisible()).map(each -> ((ColumnProjectionSegment)each).getColumn()).collect(Collectors.toList());
    }

    private static /* synthetic */ SubquerySegment lambda$bind$3(SQLStatementBinderContext binderContext, Multimap tableBinderContexts, SubquerySegment optional) {
        return SubquerySegmentBinder.bind(optional, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts);
    }

    private static /* synthetic */ SetAssignmentSegment lambda$bind$2(SQLStatementBinderContext binderContext, Multimap tableBinderContexts, SetAssignmentSegment optional) {
        return AssignmentSegmentBinder.bind(optional, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)LinkedHashMultimap.create());
    }

    private static /* synthetic */ SimpleTableSegment lambda$bind$1(SQLStatementBinderContext binderContext, Multimap tableBinderContexts, SimpleTableSegment optional) {
        return SimpleTableSegmentBinder.bind(optional, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts);
    }
}

