/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.ddl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.engine.segment.ddl.column.RenameTableDefinitionSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementCopyUtils;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.RenameTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.RenameTableStatement;

public final class RenameTableStatementBinder
implements SQLStatementBinder<RenameTableStatement> {
    @Override
    public RenameTableStatement bind(RenameTableStatement sqlStatement, SQLStatementBinderContext binderContext) {
        Collection boundRenameTables = sqlStatement.getRenameTables().stream().map(each -> RenameTableDefinitionSegmentBinder.bind(each, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)LinkedHashMultimap.create())).collect(Collectors.toList());
        return RenameTableStatementBinder.copy(sqlStatement, boundRenameTables);
    }

    private static RenameTableStatement copy(RenameTableStatement sqlStatement, Collection<RenameTableDefinitionSegment> boundRenameTables) {
        RenameTableStatement result = new RenameTableStatement(sqlStatement.getDatabaseType(), boundRenameTables);
        SQLStatementCopyUtils.copyAttributes((SQLStatement)sqlStatement, (SQLStatement)result);
        return result;
    }
}

