/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.ddl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementCopyUtils;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.DropIndexStatement;

public final class DropIndexStatementBinder
implements SQLStatementBinder<DropIndexStatement> {
    @Override
    public DropIndexStatement bind(DropIndexStatement sqlStatement, SQLStatementBinderContext binderContext) {
        if (!sqlStatement.getSimpleTable().isPresent()) {
            return sqlStatement;
        }
        return this.copy(sqlStatement, SimpleTableSegmentBinder.bind((SimpleTableSegment)sqlStatement.getSimpleTable().get(), binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)LinkedHashMultimap.create()));
    }

    private DropIndexStatement copy(DropIndexStatement sqlStatement, SimpleTableSegment boundTable) {
        DropIndexStatement result = new DropIndexStatement(sqlStatement.getDatabaseType());
        result.setSimpleTable(boundTable);
        result.getIndexes().addAll(sqlStatement.getIndexes());
        sqlStatement.getAlgorithmType().ifPresent(arg_0 -> ((DropIndexStatement)result).setAlgorithmType(arg_0));
        sqlStatement.getLockTable().ifPresent(arg_0 -> ((DropIndexStatement)result).setLockTable(arg_0));
        result.setIfExists(sqlStatement.isIfExists());
        SQLStatementCopyUtils.copyAttributes((SQLStatement)sqlStatement, (SQLStatement)result);
        return result;
    }
}

