/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.ddl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementCopyUtils;
import org.apache.shardingsphere.infra.binder.engine.statement.dml.SelectStatementBinder;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class CreateViewStatementBinder
implements SQLStatementBinder<CreateViewStatement> {
    @Override
    public CreateViewStatement bind(CreateViewStatement sqlStatement, SQLStatementBinderContext binderContext) {
        SimpleTableSegment boundView = SimpleTableSegmentBinder.bind(sqlStatement.getView(), binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)LinkedHashMultimap.create());
        SelectStatement boundSelect = new SelectStatementBinder().bind(sqlStatement.getSelect(), binderContext);
        return this.copy(sqlStatement, boundView, boundSelect);
    }

    private CreateViewStatement copy(CreateViewStatement sqlStatement, SimpleTableSegment boundView, SelectStatement boundSelect) {
        CreateViewStatement result = new CreateViewStatement(sqlStatement.getDatabaseType());
        result.setView(boundView);
        result.setSelect(boundSelect);
        result.setReplaceView(sqlStatement.isReplaceView());
        result.setViewDefinition(sqlStatement.getViewDefinition());
        SQLStatementCopyUtils.copyAttributes((SQLStatement)sqlStatement, (SQLStatement)result);
        return result;
    }
}

